% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{raw_df_injuries}
\alias{raw_df_injuries}
\title{Minimal example of injury data}
\format{
A data frame with 82 rows corresponding to 23 players and 11
variables: \describe{
\item{player_name}{Name of the football player (factor)}
\item{player_id}{Identification number of the football player (factor)}
\item{season}{Season to which this player's entry corresponds (factor)}
\item{from}{Date of the injury of each data entry (Date)}
\item{until}{Date of the recovery of each data entry (Date)}
\item{days_lost}{Number of days lost due to injury (numeric)}
\item{games_lost}{Number of matches lost due to injury (numeric)}
\item{injury}{Injury specification as it appears in \url{https://www.transfermarkt.com} (character)}
\item{injury_acl}{Whether it is Anterior Cruciate Ligament (ACL) injury or not (NO_ACL)}
\item{injury_type}{A five level categorical variable indicating the type of
injury, whether Bone, Concussion, Ligament, Muscle or Unknown; if any, NA
otherwise (factor)}
\item{injury_severity}{A four level categorical variable indicating the
severity of the injury (if any), whether Minor (<7 days lost), Moderate
([7, 28) days lost), Severe ([28, 84) days lost) or
Very_severe (>=84 days lost); NA otherwise (factor)} }
}
\source{
\url{https://www.transfermarkt.com/}
}
\usage{
raw_df_injuries
}
\description{
An example of an injury data set containing minimum required injury
information as well as other further injury-related variables. It includes
Liverpool Football Club male's first team players' injury data. Each row
refers to player-injury. These data have been scrapped from
\url{https://www.transfermarkt.com/} website using self-defined \strong{R} code
with \code{rvest} and \code{xml2} packages.
}
\note{
This data frame is provided for illustrative purposes. We warn that
they might not be accurate, there might be a mismatch and non-completeness
with what actually occurred. As such, its use cannot be recommended for
epidemiological research (see also Hoenig et al., 2022).
}
\references{
Hoenig, T., Edouard, P., Krause, M., Malhan, D., Relógio, A.,
Junge, A., & Hollander, K. (2022). Analysis of more than 20,000 injuries in
European professional football by using a citizen science-based approach:
An opportunity for epidemiological research?. \emph{Journal of science and
medicine in sport}, 25(4), 300-305.
}
\keyword{datasets}
