% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gg_injphoto.R
\name{gg_injphoto}
\alias{gg_injphoto}
\title{Plot injuries over the follow-up period}
\usage{
gg_injphoto(injd, title = NULL, fix = FALSE, by_date = "1 months")
}
\arguments{
\item{injd}{Prepared data. An \code{injd} object.}

\item{title}{Text for the main title.}

\item{fix}{A logical value indicating whether to limit the range of date (x
scale) to the maximum observed exposure date or not to limit the x
scale, regardless some recovery dates might be longer than the
maximum observed exposure date.}

\item{by_date}{increment of the date sequence at which x-axis tick-marks are
to drawn. An argument to be passed to
\code{\link[base:seq.Date]{base::seq.Date()}}.}
}
\value{
A ggplot object (to which optionally more layers can be added).
}
\description{
Given an \code{injd} \strong{S3} object it plots an overview of the injuries
sustained by each player/athlete in the cohort during the follow-up. Each
subject timeline is depicted horizontally where the red cross indicates the
exact injury date, the blue circle the recovery date and the bold black line
indicates the duration of the injury (time-loss).
}
\examples{
\donttest{
df_exposures <- prepare_exp(raw_df_exposures, player = "player_name",
                            date = "year", time_expo = "minutes_played")
df_injuries  <- prepare_inj(raw_df_injuries, player = "player_name",
                            date_injured = "from", date_recovered = "until")
injd         <- prepare_all(data_exposures = df_exposures,
                            data_injuries  = df_injuries,
                            exp_unit = "minutes")
}

gg_injphoto(injd, title = "Injury Overview", by_date = "1 years")
}
