% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/arith_assignment.R
\name{\%*=\%}
\alias{\%*=\%}
\title{Multiplication variable reassignment}
\usage{
lhs \%*=\% rhs
}
\arguments{
\item{lhs}{An numeric object existing in the global/
parent environment.}

\item{rhs}{A numeric value to multiply the lhs by}
}
\value{
Returns the arithmetically-updated left-hand
object into the environment the operation was performed in.
}
\description{
Updates the left-hand, numeric type object by multiplying
it by the right-hand value, reassigning the product to
the left-hand object.
}
\details{
Currently in R, if you want to update the value
of a numeric object to be the outcome of some
arithmetic operation, you have to initialize the
object and then reassign it. For example:
\code{apple <- 2} and then \code{apple <- apple * 3}. This
sort of thing is generally referred to as
augmented variable assignment. This function allows
users to update the value of an object through
multiplying it by the value on the right-hand side.
}
\examples{
{

example <- 3
example \%*=\% 4
example # returns 12

}
}
