% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/arith_assignment.R
\name{\%-=\%}
\alias{\%-=\%}
\title{Subtraction variable reassignment}
\usage{
lhs \%-=\% rhs
}
\arguments{
\item{lhs}{An numeric object existing in the global/
parent environment.}

\item{rhs}{A numeric value to subtract from the lhs}
}
\value{
Returns the arithmetically-updated left-hand
object into the environment the operation was performed in.
}
\description{
Updates the left-hand, numeric type object by subtracting
the right-hand value from it, reassigning the difference to
the left-hand object.
}
\details{
Currently in R, if you want to update the value
of a numeric object to be the outcome of some
arithmetic operation, you have to initialize the
object and then reassign it. For example:
\code{apple <- 1} and then \code{apple <- apple - 1}. This
sort of thing is generally referred to as
augmented variable assignment. This function allows
users to update the value of an object through
subtracting the value on the right-hand side.
}
\examples{
{

example <- 10
example \%-=\% 3
example # returns 7

}
}
