% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{get_args}
\alias{get_args}
\title{Get arguments from a function}
\usage{
get_args(FUN, args_list = NULL, ...)
}
\arguments{
\item{FUN}{function for which to find arguments}

\item{args_list}{a list of arguments. Defaults to NULL.}

\item{...}{any arguments. Those necessary for FUN must be named as appropriate for FUN}
}
\value{
list of arguments for FUN
}
\description{
Extracts the names of the arguments from a function, and creates a list
of those arguments where they exist in ... .
}
\examples{
myargs <- get_args(lm, formula = Sepal.Length ~ Sepal.Width, data = iris )
summary(do.call('lm', myargs))
}
