% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_influenza_cdc_ili.R
\name{get_influenza_cdc_ili}
\alias{get_influenza_cdc_ili}
\title{Get CDC Influenza-like Illness (ILI) Data}
\usage{
get_influenza_cdc_ili()
}
\value{
A list containing:
\itemize{
  \item \code{updated}: Last update timestamp (POSIXct).
  \item \code{source}: Source of the data.
  \item \code{data}: A data frame with the following columns:
  \itemize{
    \item \code{week}: Week of reporting.
    \item \code{age 5-24}, \code{age 25-49}, \code{age 50-64}, \code{age 64+}: ILI counts per age group.
    \item \code{totalILI}: Total ILI cases.
    \item \code{totalPatients}: Total patients.
  }
}
Returns \code{NULL} if the API is unavailable or an error occurs.
}
\description{
Retrieves ILI data for the 2019 and 2020 influenza outbreaks from the US CDC.
}
\details{
This endpoint provides historical data for flu-like symptoms reported in the United States, sourced from the CDC ILINet.
Requires an active internet connection.
}
\note{
Requires internet connection. Function fails gracefully if API is unavailable.
}
\examples{
\dontrun{
ili_data <- get_influenza_cdc_ili()
if (!is.null(ili_data)) {
  print(ili_data$updated)
  head(ili_data$data)
}
}

}
\references{
API Docs: https://disease.sh/docs/#/Influenza/get_v3_influenza_cdc_ILINet
}
