% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-documentation.R
\name{ecoli_infections_df}
\alias{ecoli_infections_df}
\title{E. coli Infections Time Series}
\format{
A data frame with 646 observations and 3 variables:
\describe{
  \item{year}{Numeric variable indicating the calendar year of observation}
  \item{week}{Numeric variable indicating the calendar week (1 to 52 or 53)}
  \item{cases}{Numeric variable representing the number of reported \emph{E. coli} cases}
}
}
\source{
Data taken from the tscount package version 1.4.3
}
\usage{
data(ecoli_infections_df)
}
\description{
This dataset, ecoli_infections_df, is a data frame containing the weekly number of reported
disease cases caused by \emph{Escherichia coli} in the state of North Rhine-Westphalia (Germany)
from January 2001 to May 2013. The data excludes cases of EHEC (enterohemorrhagic
\emph{E. coli}) and HUS (hemolytic uremic syndrome).
}
\details{
The dataset name has been kept as 'ecoli_infections_df' to avoid confusion with other datasets
in the R ecosystem. This naming convention helps distinguish this dataset as part of the
infectiousR package and assists users in identifying its specific characteristics.
The suffix 'df' indicates that the dataset is a data frame. The original content has not been modified
in any way.
}
