\name{meanerrba}
\alias{meanerrba}

\title{
Mean and error intervals
}
\description{
Mean and error intervals, either represent the mean values as a character 
(e.g., dot, solid square, etc.) or the height of bars. Error intervals are 
back-transformed from regular link functions included in <<glm>>, but the user 
can customize the back transformation by introducing a function in the form of, 
<<function(x)log1p(x)>>
}

\usage{
meanerrba(means, error, link=NA, backtrans=NULL, bars= FALSE, 
legend.text=FALSE, ylab="Mean and error", xlab="Groups", main="", pch=19, 
cex = 1, cex.pt=1, cex.axis = 1, cex.lab = 1, cex.main = 2, col= "grey", 
border= "grey30", density=NULL, angle=NULL, lwd=1, axis.lty=0, 
names.arg = colnames(means), las = 1, ylim = FALSE, axes = TRUE, xpd = FALSE, 
add = FALSE)
}

\arguments{
  \item{means}{
  A vector or matrix with mean values. If a matrix, each column of values is 
  grouped in the figure
}
  \item{error}{
  A vector or matrix with error values. If a matrix, each column of values is 
  grouped in the figure
}
  \item{link}{
  Specified the scale of the linear predictor used to calculate the mean and 
  error values and apply the corresponding back transformation in the plot.
}
  \item{backtrans}{
  Define the customized back transformation if needed.
}
  \item{bars}{
  Logical values to whether bars should be represented in the plot. The default 
  option is FALSE, and mean values are represented with character, e.g., dot, 
  open square, etc., as defined with the <<pch>> argument.
}
  \item{legend.text}{
  Optional when bars=TRUE: A character vector to ID bars in the groups. The 
  length of the vector must match the number of rows in the means matrix or 
  the length of the means vector.
}
  \item{ylab}{
  Label for the y-axis.
}
  \item{xlab}{
  Label for the x-axis.
}
  \item{main}{
  Label for the heading of the figure.
}
  \item{pch}{
  Character to represent the mean values when teh bars argumen is FALSE.
}
  \item{cex}{
  Character expansion factor for the names of the groups.
}
  \item{cex.pt}{
  Expansion factor for the character representing the mean value.
}
  \item{cex.axis}{
  Expansion factor for the axis values.
}
  \item{cex.lab}{
  Expansion factor for the axis labels.
}
  \item{cex.main}{
  Expansion factor for the heading of the figure.
}
  \item{col}{
  A vector for the color of the elements in each group of means.
}
  \item{border}{
  A vector for the color of the border when bars are displayed.
}
  \item{density}{
  Numeric vector for the densitity of lines of the bars.
}
  \item{angle}{
  Numeric vector for the angle of lines of the bars.
}
  \item{lwd}{
  Numeric vector for the width of lines of error intervals. Also affects the
  lines of characters as in function points().
}
  \item{axis.lty}{
  Numeric vector for the line type of the x-axis.
}
  \item{names.arg}{
  Character vectors are used to name the groups of means taken as the column 
  names of the means matrix or names of means vector elements. When names 
  are not available, they take consecutive capital letter values.
}
  \item{las}{
  Integer value (0 to 1) to fix the orientation of values in the y-axis.
}
  \item{ylim}{
  Limits of the y-axis, a vector of two elements for the lower and upper 
  limits of the axis, respectively.
}
  \item{axes}{
  Logical, wheather the y-axis should appear in the plot. Default value is TRUE
}
  \item{xpd}{
  Logical, wheather bars are expanded beyond the ylim.
}
  \item{add}{
  Logical, wheather mean and error bars should be added to an existing plot. 
  Default option is FALSE and can not be change for now.
}
}

\value{
No values returned.
}

\references{
Rohlf, F. (1981). Biometry the principles and practice of statistics in 
biological research.
Zar, J. H. (1999). Biostatistical analysis. Pearson Education India.
}

\author{
Guevara, R., roger.guevara@inecol.mx
}

\examples{
%Example 1
set.seed(42)
means <- matrix(rpois(6, 10), 2, 3)
error <- matrix(runif(6)*2, 2, 3)
meanerrba(means,error,col=c("red", "blue", "purple"), ylim=c(6, 18), xlab="")
abline(h=6, lwd=2)
legend("topright", c("2024", "2024", "2025"), col=c("red", "blue", "purple"), 
bty="n", pch=19, ncol=3)

%Example 2
set.seed(42)
means <- matrix(runif(6)*sample(c(1,-1),size=6, replace=TRUE), 2, 3)
error <- matrix(runif(6), 2, 3)/5
meanerrba(t(means),t(error), link="logit", ylim=c(0.2, 0.8), 
names=paste("Group",1:3, sep="-"), col=c("blue", "purple"), xlab="")
abline(h=0.2, lwd=2)
legend("topleft", c("Condition A", "Condition B"), col=c("blue", "purple"), 
bty="n", pch=c(19,15))

%Example 3
set.seed(42)
means <- matrix(runif(6)*sample(c(1,-1),size=6, replace=TRUE), 2, 3)
error <- matrix(runif(6), 2, 3)/5
meanerrba(t(means),t(error), link="logit", ylim=c(0.2, 0.8), 
names=paste("Group",1:3, sep="-"), col="blue", pch=c(0,5), xlab="")
legend("topleft", c("2024", "2025"), col="blue", bty="n", pch=c(0,5))

%Example 4
set.seed(42)
means <- matrix(runif(6)*sample(c(1,-1),size=6, replace=TRUE), 2, 3)
error <- matrix(runif(6), 2, 3)/5
meanerrba(t(means),t(error), link="logit", bars=TRUE, col=c("navy", "gold2"), 
ylim=c(0.2, 0.8), xlab="")
legend("topleft", c("2024", "2025"), fill=c("navy", "gold2"), bty="n")
}