\name{hcsrt}
\alias{hcsrt}

\title{
Homocedasticity test
}
\description{
Test of homocedasticity for lm glm and glmer models based on the trend of the 
squared residuals as a function of the fitted values
}
\usage{
hcsrt(M)
}

\arguments{
  \item{M}{
  A lm, glm or glmer model.
}
}

\value{
Returns the ANOVA table for the test. Nonsignificant effects mean there is no 
evidence to reject the null hypothesis that variability is the same across the 
fitted values range.
}

\references{
Rohlf, F. (1981). Biometry the principles and practice of statistics in 
biological research.
Zar, J. H. (1999). Biostatistical analysis. Pearson Education India.
}

\author{
Guevara, R., roger.guevara@inecol.mx
}

\examples{
%Example 1
y <- sort(rnorm(20, 5, 2))
x <- c(1:20)
M <- lm(y~x)
hcsrt(M)
}
