% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/elicit_functions.R
\name{makeSweave}
\alias{makeSweave}
\title{Function to create summary document from a saved elicitation record.}
\usage{
makeSweave(
  filename.rds = "",
  reportname = "",
  title = "Elicitation record",
  contact.details = "none",
  fitted.fractiles = TRUE,
  cumul.prob.bounds = c(0.05, 0.95)
)
}
\arguments{
\item{filename.rds}{character, filename of the record saved as an RDS object,
see \code{?saveRDS}.}

\item{reportname}{character, filename without extension to be used for the 
generated Sweave (\code{.Rnw}) file. The Sweave file supports the creation
of report (\code{.pdf}) documentation and accompanying files such as the
\code{.tex} file generated by using \code{\link[utils]{Sweave}} followed by
\code{tools::texi2pdf()}.}

\item{title}{character, a title for the report}

\item{contact.details}{character, an email address or other mechanism by 
which the expert may contact the facilitator or rapporteur}

\item{fitted.fractiles}{logical or numeric vector. A logical value of
\code{FALSE} will not plot any fitted fractiles from the fitted subjective
probability distribution. A logical value of \code{TRUE} will plot the
fitted fractiles that correspond to the final iteration of the raw elicited
fractiles. Alternatively, a numeric vector can specify arbitrary fractiles
for plotting from the fitted distribution, e.g., \code{c(1/10, 1/4, 1/2,
3/4, 9/10)}}

\item{cumul.prob.bounds}{numeric vector that specifies the upper and lower 
plot bounds determined by this credible interval. The default is the 0.90 
central credible interval, \code{c(0.05, 0.95)}}
}
\description{
Creates a Sweave file that can be used to generate a pdf document of the 
summary report.
}
\examples{
\dontrun{ 
X <- matrix(c(1, 1, 0, 1), nrow = 2) # design
Z <- designLink(design = X)
Z <- elicitPt(Z, design.pt = 1,
  lower.CI.bound = -1,
  median = 0,
  upper.CI.bound = 1,
  comment = "A completed elicitation scenario.")
tmp.rds <- tempfile(pattern = "record", fileext =".rds")
saveRecord(Z, file = tmp.rds)
tmpReport <- tempfile(pattern = "report")
makeSweave(filename.rds = tmp.rds, reportname = tmpReport)
setwd(tempdir())
utils::Sweave(paste0(tmpReport, ".Rnw"))
tools::texi2pdf(paste0(tmpReport, ".tex")) 
}
}
