% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/independence_weights_estimation.R
\name{weighted_energy_stats}
\alias{weighted_energy_stats}
\title{Calculation of weighted energy statistics for weighted dependence}
\usage{
weighted_energy_stats(A, X, weights, dimension_adj = TRUE)
}
\arguments{
\item{A}{treatment vector indicating values of the treatment/exposure variable.}

\item{X}{matrix of covariates with number of rows equal to the length of \code{weights} and each column is a
covariate}

\item{weights}{a vector of sample weights}

\item{dimension_adj}{logical scalar. Whether or not to add adjustment to energy distance terms that account for
the dimensionality of \code{x}. Defaults to \code{TRUE}.}
}
\value{
a list with the following components
\item{D_w}{The value of the weighted dependence distance of Huling, et al. (2021) using the optimal estimated weights.
This is the weighted dependence statistic without the ridge penalty on the weights.}
\item{distcov_unweighted}{The unweighted distance covariance term. This is the standard distance covariance of Szekely et al (2007). This term
is always equal to \code{D_unweighted}.}
\item{distcov_weighted}{The weighted distance covariance term. This term itself does not directly measure weighted dependence but is a critical component of it.  }
\item{energy_A}{The weighted energy distance between \code{A} and its weighted version}
\item{energy_X}{The weighted energy distance between \code{X} and its weighted version}
\item{ess}{The estimated effective sample size of the weights using Kish's effective sample size formula.}

An object of class \code{"weighted_energy_terms"}.
\item{D_w}{the value of the DCOW measure}
\item{distcov_unweighted}{the unweighted distance covariance between treatment and covariates}
\item{distcov_weighted}{the weighted distance covariance between treatment and covariates}
\item{energy_A}{the (energy) distance between the treatment distribution and the weighted treatment distribution. Smaller values mean the marginal distribution of the treatment is preserved after weighting}
\item{energy_x}{the (energy) distance between the covariate distribution and the weighted covariate distribution. Smaller values mean the marginal distribution of the covariates is preserved after weighting}
\item{ess}{the expected sample size after weighting. Kish's approximation is used}
}
\description{
Calculates weighted energy statistics used to quantify weighted dependence
}
\examples{

simdat <- simulate_confounded_data(seed = 999, nobs = 100)

str(simdat$data)

A <- simdat$data$A
X <- as.matrix(simdat$data[c("Z1", "Z2", "Z3", "Z4", "Z5")])

wts <- runif(length(A))

weighted_energy_stats(A, X, wts)

}
\references{
Szekely, G. J., Rizzo, M. L., & Bakirov, N. K. (2007). Measuring and testing dependence by correlation of distances.
Annals of Statistics 35(6) 2769-2794 \doi{10.1214/009053607000000505}

Huling, J. D., Greifer, N., & Chen, G. (2021). Independence weights for causal inference with continuous exposures.
arXiv preprint arXiv:2107.07086. \url{https://arxiv.org/abs/2107.07086}
}
