% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate_g2.R
\name{simulate_g2}
\alias{simulate_g2}
\title{Simulate \eqn{g2}}
\usage{
simulate_g2(n_ind = NULL, H_nonInb = 0.5, meanF = 0.2, varF = 0.03,
  subsets = NULL, reps = 100, type = c("msats", "snps"), CI = 0.95)
}
\arguments{
\item{n_ind}{number of individuals to sample from the population}

\item{H_nonInb}{true genome-wide heteorzygosity of a non-inbred individual}

\item{meanF}{mean realized inbreeding f}

\item{varF}{variance in realized inbreeding f}

\item{subsets}{a vector specifying the sizes of marker-subsets to draw. Specifying  \code{subsets = c(2, 5, 10, 15, 20)} 
would draw marker sets of 2 to 20 markers. The minimum number of markers to calculate g2 is 2.}

\item{reps}{number of resampling repetitions}

\item{type}{specifies g2 formula. Type "snps" for large datasets and "msats" for smaller datasets.}

\item{CI}{Confidence intervals to calculate (default to 0.95)}
}
\value{
\code{simulate_g2} returns an object of class "inbreed".
The functions `print` and `plot` are used to print a summary and to plot the g2 values with means and confidence intervals

An `inbreed` object from  \code{simulate_g2} is a list containing the following components:
\item{call}{function call.}
\item{estMat}{matrix with all r2(h,f) estimates. Each row contains the values for a given subset of markers}
\item{true_g2}{"true" g2 value based on the assigned realized inbreeding values}
\item{n_ind}{specified number of individuals}
\item{subsets}{vector specifying the marker sets}
\item{reps}{repetitions per subset}
\item{H_nonInb}{true genome-wide heteorzygosity of a non-inbred individual}
\item{meanF}{mean realized inbreeding f}
\item{varF}{variance in realized inbreeding f}
\item{min_val}{minimum g2 value}
\item{max_val}{maximum g2 value}
\item{all_CI}{confidence intervals for all subsets}
\item{all_sd}{standard deviations for all subsets}
}
\description{
This function can be used to simulate genotype data, draw subsets of loci and calculate the
respective \eqn{g2} values. Every subset of markers is drawn independently to give insights
into the variation and precision of \eqn{g2} calculated from a given number of markers and individuals.
}
\details{
The \code{simulate_g2} function simulates genotypes from which subsets of loci can be sampled independently. 
         These simulations can be used to evaluate the effects of the number of individuals 
         and loci on the precision and magnitude of \eqn{g2}. The user specifies the number of simulated individuals (\code{n_ind}), the subsets of 
         loci (\code{subsets}) to be drawn, the heterozygosity of non-inbred individuals (\code{H_nonInb}) and the 
         distribution of \emph{f} among the simulated individuals. The \emph{f} values of the simulated individuals are sampled
         randomly from a beta distribution with mean (\code{meanF}) and variance (\code{varF}) specified by the user 
         (e.g. as in wang2011). This enables the simulation to mimic populations with known inbreeding 
         characteristics, or to simulate hypothetical scenarios of interest. For computational simplicity, allele 
         frequencies are assumed to be constant across all loci and the simulated loci are unlinked. Genotypes
         (i.e. the heterozygosity/homozygosity status at each locus) are assigned stochastically based on the \emph{f}
         values of the simulated individuals. Specifically, the probability of an individual being heterozygous at
         any given locus (\eqn{H}) is expressed as \eqn{H = H0(1-f)} , where \eqn{H0} is the user-specified heterozygosity of a 
         non-inbred individual and \emph{f} is an individual's inbreeding coefficient drawn from the beta distribution.
}
\examples{
data(mouse_msats)
genotypes <- convert_raw(mouse_msats)
sim_g2 <- simulate_g2(n_ind = 10, H_nonInb = 0.5, meanF = 0.2, varF = 0.03,
                      subsets = c(4,6,8,10), reps = 100, 
                      type = "msats")
plot(sim_g2)
}
\author{
Marty Kardos (marty.kardos@ebc.uu.se) &
         Martin A. Stoffel (martin.adam.stoffel@gmail.com)
}
