% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/r2_hf.R
\name{r2_hf}
\alias{r2_hf}
\title{Expected r2 between standardized multilocus heterozygosity (h) and inbreeding level (f)}
\usage{
r2_hf(genotypes, type = c("msats", "snps"), nboot = NULL,
  parallel = FALSE, ncores = NULL, CI = 0.95)
}
\arguments{
\item{genotypes}{\code{data.frame} with individuals in rows and loci in columns,
containing genotypes coded as 0 (homozygote), 1 (heterozygote) and \code{NA} (missing)}

\item{type}{specifies g2 formula to take. Type "snps" for large datasets and "msats" for smaller datasets.}

\item{nboot}{number of bootstraps over individuals to estimate a confidence interval
around r2(h, f)}

\item{parallel}{Default is FALSE. If TRUE, bootstrapping and permutation tests are parallelized}

\item{ncores}{Specify number of cores to use for parallelization. By default,
all available cores but one are used.}

\item{CI}{confidence interval (default to 0.95)}
}
\value{
\item{call}{function call.}
\item{r2_hf_full}{expected r2 between inbreeding and sMLH for the full dataset}
\item{r2_hf_boot}{expected r2 values from bootstrapping over individuals}
\item{CI_boot}{confidence interval around the expected r2}
\item{nobs}{number of observations}
\item{nloc}{number of markers}
}
\description{
Expected r2 between standardized multilocus heterozygosity (h) and inbreeding level (f)
}
\examples{
data(mouse_msats)
genotypes <- convert_raw(mouse_msats)
(out <- r2_hf(genotypes, nboot = 100, type = "msats", parallel = FALSE))
plot(out)
}
\references{
Slate, J., David, P., Dodds, K. G., Veenvliet, B. A., Glass, B. C., Broad, T. E., & McEwan, J. C. (2004). 
Understanding the relationship between the inbreeding coefficient 
and multilocus heterozygosity: theoretical expectations and empirical data. Heredity, 93(3), 255-265.

Szulkin, M., Bierne, N., & David, P. (2010). HETEROZYGOSITY-FITNESS CORRELATIONS: A TIME FOR REAPPRAISAL. 
Evolution, 64(5), 1202-1217.
}
\author{
Martin A. Stoffel (martin.adam.stoffel@gmail.com)
}
