// Generated by rstantools.  Do not edit by hand.

/*
    im is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    im is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with im.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef MODELS_HPP
#define MODELS_HPP
#define STAN__SERVICES__COMMAND_HPP
#ifndef USE_STANC3
#define USE_STANC3
#endif
#include <rstan/rstaninc.hpp>
// Code generated by stanc v2.32.2
#include <stan/model/model_header.hpp>
namespace model_NB_namespace {
using stan::model::model_base_crtp;
using namespace stan::math;
stan::math::profile_map profiles__;
static constexpr std::array<const char*, 48> locations_array__ =
  {" (found before start of program)",
  " (in 'NB', line 33, column 2 to column 13)",
  " (in 'NB', line 34, column 2 to column 17)",
  " (in 'NB', line 35, column 2 to column 15)",
  " (in 'NB', line 36, column 2 to column 11)",
  " (in 'NB', line 39, column 2 to column 26)",
  " (in 'NB', line 42, column 9 to column 10)",
  " (in 'NB', line 42, column 2 to column 16)",
  " (in 'NB', line 43, column 9 to column 10)",
  " (in 'NB', line 43, column 2 to column 16)",
  " (in 'NB', line 44, column 2 to column 33)",
  " (in 'NB', line 45, column 2 to column 25)",
  " (in 'NB', line 46, column 2 to column 25)",
  " (in 'NB', line 47, column 2 to column 23)",
  " (in 'NB', line 48, column 2 to column 22)",
  " (in 'NB', line 49, column 2 to column 22)",
  " (in 'NB', line 50, column 2 to column 24)",
  " (in 'NB', line 55, column 6 to column 41)",
  " (in 'NB', line 54, column 11 to line 56, column 5)",
  " (in 'NB', line 53, column 6 to column 41)",
  " (in 'NB', line 52, column 23 to line 54, column 5)",
  " (in 'NB', line 52, column 4 to line 56, column 5)",
  " (in 'NB', line 51, column 17 to line 57, column 3)",
  " (in 'NB', line 51, column 2 to line 57, column 3)",
  " (in 'NB', line 14, column 2 to column 8)",
  " (in 'NB', line 15, column 2 to column 8)",
  " (in 'NB', line 16, column 8 to column 9)",
  " (in 'NB', line 16, column 2 to column 11)",
  " (in 'NB', line 17, column 9 to column 10)",
  " (in 'NB', line 17, column 12 to column 13)",
  " (in 'NB', line 17, column 2 to column 17)",
  " (in 'NB', line 18, column 9 to column 10)",
  " (in 'NB', line 18, column 2 to column 18)",
  " (in 'NB', line 19, column 2 to column 16)",
  " (in 'NB', line 20, column 2 to column 23)",
  " (in 'NB', line 23, column 9 to column 10)",
  " (in 'NB', line 23, column 12 to column 13)",
  " (in 'NB', line 23, column 2 to column 21)",
  " (in 'NB', line 24, column 9 to column 10)",
  " (in 'NB', line 24, column 2 to column 19)",
  " (in 'NB', line 25, column 9 to column 10)",
  " (in 'NB', line 25, column 2 to column 17)",
  " (in 'NB', line 27, column 4 to column 28)",
  " (in 'NB', line 28, column 4 to column 24)",
  " (in 'NB', line 29, column 4 to column 46)",
  " (in 'NB', line 26, column 17 to line 30, column 3)",
  " (in 'NB', line 26, column 2 to line 30, column 3)",
  " (in 'NB', line 34, column 9 to column 10)"};
#include <stan_meta_header.hpp>
class model_NB final : public model_base_crtp<model_NB> {
private:
  int N;
  int K;
  std::vector<int> y;
  Eigen::Matrix<double,-1,-1> X_data__;
  Eigen::Matrix<double,-1,1> treat_data__;
  double tau_mean;
  double tau_sd;
  Eigen::Matrix<double,-1,-1> X_std_data__;
  Eigen::Matrix<double,-1,1> mean_X_data__;
  Eigen::Matrix<double,-1,1> sd_X_data__;
  Eigen::Map<Eigen::Matrix<double,-1,-1>> X{nullptr, 0, 0};
  Eigen::Map<Eigen::Matrix<double,-1,1>> treat{nullptr, 0};
  Eigen::Map<Eigen::Matrix<double,-1,-1>> X_std{nullptr, 0, 0};
  Eigen::Map<Eigen::Matrix<double,-1,1>> mean_X{nullptr, 0};
  Eigen::Map<Eigen::Matrix<double,-1,1>> sd_X{nullptr, 0};
public:
  ~model_NB() {}
  model_NB(stan::io::var_context& context__, unsigned int random_seed__ = 0,
           std::ostream* pstream__ = nullptr) : model_base_crtp(0) {
    int current_statement__ = 0;
    using local_scalar_t__ = double;
    boost::ecuyer1988 base_rng__ =
      stan::services::util::create_rng(random_seed__, 0);
    // suppress unused var warning
    (void) base_rng__;
    static constexpr const char* function__ = "model_NB_namespace::model_NB";
    // suppress unused var warning
    (void) function__;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    // suppress unused var warning
    (void) DUMMY_VAR__;
    try {
      int pos__ = std::numeric_limits<int>::min();
      pos__ = 1;
      current_statement__ = 24;
      context__.validate_dims("data initialization", "N", "int",
        std::vector<size_t>{});
      N = std::numeric_limits<int>::min();
      current_statement__ = 24;
      N = context__.vals_i("N")[(1 - 1)];
      current_statement__ = 25;
      context__.validate_dims("data initialization", "K", "int",
        std::vector<size_t>{});
      K = std::numeric_limits<int>::min();
      current_statement__ = 25;
      K = context__.vals_i("K")[(1 - 1)];
      current_statement__ = 26;
      stan::math::validate_non_negative_index("y", "N", N);
      current_statement__ = 27;
      context__.validate_dims("data initialization", "y", "int",
        std::vector<size_t>{static_cast<size_t>(N)});
      y = std::vector<int>(N, std::numeric_limits<int>::min());
      current_statement__ = 27;
      y = context__.vals_i("y");
      current_statement__ = 28;
      stan::math::validate_non_negative_index("X", "N", N);
      current_statement__ = 29;
      stan::math::validate_non_negative_index("X", "K", K);
      current_statement__ = 30;
      context__.validate_dims("data initialization", "X", "double",
        std::vector<size_t>{static_cast<size_t>(N), static_cast<size_t>(K)});
      X_data__ = Eigen::Matrix<double,-1,-1>::Constant(N, K,
                   std::numeric_limits<double>::quiet_NaN());
      new (&X) Eigen::Map<Eigen::Matrix<double,-1,-1>>(X_data__.data(), N, K);
      {
        std::vector<local_scalar_t__> X_flat__;
        current_statement__ = 30;
        X_flat__ = context__.vals_r("X");
        current_statement__ = 30;
        pos__ = 1;
        current_statement__ = 30;
        for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
          current_statement__ = 30;
          for (int sym2__ = 1; sym2__ <= N; ++sym2__) {
            current_statement__ = 30;
            stan::model::assign(X, X_flat__[(pos__ - 1)],
              "assigning variable X", stan::model::index_uni(sym2__),
              stan::model::index_uni(sym1__));
            current_statement__ = 30;
            pos__ = (pos__ + 1);
          }
        }
      }
      current_statement__ = 31;
      stan::math::validate_non_negative_index("treat", "N", N);
      current_statement__ = 32;
      context__.validate_dims("data initialization", "treat", "double",
        std::vector<size_t>{static_cast<size_t>(N)});
      treat_data__ = Eigen::Matrix<double,-1,1>::Constant(N,
                       std::numeric_limits<double>::quiet_NaN());
      new (&treat)
        Eigen::Map<Eigen::Matrix<double,-1,1>>(treat_data__.data(), N);
      {
        std::vector<local_scalar_t__> treat_flat__;
        current_statement__ = 32;
        treat_flat__ = context__.vals_r("treat");
        current_statement__ = 32;
        pos__ = 1;
        current_statement__ = 32;
        for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
          current_statement__ = 32;
          stan::model::assign(treat, treat_flat__[(pos__ - 1)],
            "assigning variable treat", stan::model::index_uni(sym1__));
          current_statement__ = 32;
          pos__ = (pos__ + 1);
        }
      }
      current_statement__ = 33;
      context__.validate_dims("data initialization", "tau_mean", "double",
        std::vector<size_t>{});
      tau_mean = std::numeric_limits<double>::quiet_NaN();
      current_statement__ = 33;
      tau_mean = context__.vals_r("tau_mean")[(1 - 1)];
      current_statement__ = 34;
      context__.validate_dims("data initialization", "tau_sd", "double",
        std::vector<size_t>{});
      tau_sd = std::numeric_limits<double>::quiet_NaN();
      current_statement__ = 34;
      tau_sd = context__.vals_r("tau_sd")[(1 - 1)];
      current_statement__ = 34;
      stan::math::check_greater_or_equal(function__, "tau_sd", tau_sd, 0);
      current_statement__ = 35;
      stan::math::validate_non_negative_index("X_std", "N", N);
      current_statement__ = 36;
      stan::math::validate_non_negative_index("X_std", "K", K);
      current_statement__ = 37;
      X_std_data__ = Eigen::Matrix<double,-1,-1>::Constant(N, K,
                       std::numeric_limits<double>::quiet_NaN());
      new (&X_std)
        Eigen::Map<Eigen::Matrix<double,-1,-1>>(X_std_data__.data(), N, K);
      current_statement__ = 38;
      stan::math::validate_non_negative_index("mean_X", "K", K);
      current_statement__ = 39;
      mean_X_data__ = Eigen::Matrix<double,-1,1>::Constant(K,
                        std::numeric_limits<double>::quiet_NaN());
      new (&mean_X)
        Eigen::Map<Eigen::Matrix<double,-1,1>>(mean_X_data__.data(), K);
      current_statement__ = 40;
      stan::math::validate_non_negative_index("sd_X", "K", K);
      current_statement__ = 41;
      sd_X_data__ = Eigen::Matrix<double,-1,1>::Constant(K,
                      std::numeric_limits<double>::quiet_NaN());
      new (&sd_X) Eigen::Map<Eigen::Matrix<double,-1,1>>(sd_X_data__.data(),
        K);
      current_statement__ = 46;
      for (int k = 1; k <= K; ++k) {
        current_statement__ = 42;
        stan::model::assign(mean_X,
          stan::math::mean(
            stan::model::rvalue(X, "X", stan::model::index_omni(),
              stan::model::index_uni(k))), "assigning variable mean_X",
          stan::model::index_uni(k));
        current_statement__ = 43;
        stan::model::assign(sd_X,
          stan::math::sd(
            stan::model::rvalue(X, "X", stan::model::index_omni(),
              stan::model::index_uni(k))), "assigning variable sd_X",
          stan::model::index_uni(k));
        current_statement__ = 44;
        stan::model::assign(X_std,
          stan::math::divide(
            stan::math::subtract(
              stan::model::rvalue(X, "X", stan::model::index_omni(),
                stan::model::index_uni(k)),
              stan::model::rvalue(mean_X, "mean_X", stan::model::index_uni(k))),
            stan::model::rvalue(sd_X, "sd_X", stan::model::index_uni(k))),
          "assigning variable X_std", stan::model::index_omni(),
          stan::model::index_uni(k));
      }
      current_statement__ = 47;
      stan::math::validate_non_negative_index("beta", "K", K);
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
    }
    num_params_r__ = 1 + K + 1 + 1;
  }
  inline std::string model_name() const final {
    return "model_NB";
  }
  inline std::vector<std::string> model_compile_info() const noexcept {
    return std::vector<std::string>{"stanc_version = stanc3 v2.32.2",
             "stancflags = --allow-undefined"};
  }
  template <bool propto__, bool jacobian__, typename VecR, typename VecI,
            stan::require_vector_like_t<VecR>* = nullptr,
            stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr>
  inline stan::scalar_type_t<VecR>
  log_prob_impl(VecR& params_r__, VecI& params_i__, std::ostream*
                pstream__ = nullptr) const {
    using T__ = stan::scalar_type_t<VecR>;
    using local_scalar_t__ = T__;
    T__ lp__(0.0);
    stan::math::accumulator<T__> lp_accum__;
    stan::io::deserializer<local_scalar_t__> in__(params_r__, params_i__);
    int current_statement__ = 0;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    // suppress unused var warning
    (void) DUMMY_VAR__;
    static constexpr const char* function__ = "model_NB_namespace::log_prob";
    // suppress unused var warning
    (void) function__;
    try {
      local_scalar_t__ alpha = DUMMY_VAR__;
      current_statement__ = 1;
      alpha = in__.template read<local_scalar_t__>();
      Eigen::Matrix<local_scalar_t__,-1,1> beta =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(K, DUMMY_VAR__);
      current_statement__ = 2;
      beta = in__.template read<Eigen::Matrix<local_scalar_t__,-1,1>>(K);
      local_scalar_t__ log_phi = DUMMY_VAR__;
      current_statement__ = 3;
      log_phi = in__.template read<local_scalar_t__>();
      local_scalar_t__ tau = DUMMY_VAR__;
      current_statement__ = 4;
      tau = in__.template read<local_scalar_t__>();
      local_scalar_t__ phi = DUMMY_VAR__;
      current_statement__ = 5;
      phi = stan::math::exp(log_phi);
      {
        current_statement__ = 6;
        stan::math::validate_non_negative_index("mu0", "N", N);
        Eigen::Matrix<local_scalar_t__,-1,1> mu0 =
          Eigen::Matrix<local_scalar_t__,-1,1>::Constant(N, DUMMY_VAR__);
        current_statement__ = 8;
        stan::math::validate_non_negative_index("mu1", "N", N);
        Eigen::Matrix<local_scalar_t__,-1,1> mu1 =
          Eigen::Matrix<local_scalar_t__,-1,1>::Constant(N, DUMMY_VAR__);
        current_statement__ = 10;
        lp_accum__.add(stan::math::normal_lpdf<propto__>(tau, tau_mean,
                         tau_sd));
        current_statement__ = 11;
        lp_accum__.add(stan::math::std_normal_lpdf<propto__>(log_phi));
        current_statement__ = 12;
        lp_accum__.add(stan::math::std_normal_lpdf<propto__>(log_phi));
        current_statement__ = 13;
        lp_accum__.add(stan::math::std_normal_lpdf<propto__>(alpha));
        current_statement__ = 14;
        lp_accum__.add(stan::math::std_normal_lpdf<propto__>(beta));
        current_statement__ = 15;
        stan::model::assign(mu0,
          stan::math::exp(stan::math::multiply(X, beta)),
          "assigning variable mu0");
        current_statement__ = 16;
        stan::model::assign(mu1, stan::math::multiply(mu0, (1 + tau)),
          "assigning variable mu1");
        current_statement__ = 23;
        for (int n = 1; n <= N; ++n) {
          current_statement__ = 21;
          if (stan::math::logical_eq(
                stan::model::rvalue(treat, "treat", stan::model::index_uni(n)),
                1)) {
            current_statement__ = 19;
            lp_accum__.add(stan::math::neg_binomial_2_lpmf<propto__>(
                             stan::model::rvalue(y, "y",
                               stan::model::index_uni(n)),
                             stan::model::rvalue(mu1, "mu1",
                               stan::model::index_uni(n)), phi));
          } else {
            current_statement__ = 17;
            lp_accum__.add(stan::math::neg_binomial_2_lpmf<propto__>(
                             stan::model::rvalue(y, "y",
                               stan::model::index_uni(n)),
                             stan::model::rvalue(mu0, "mu0",
                               stan::model::index_uni(n)), phi));
          }
        }
      }
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
    }
    lp_accum__.add(lp__);
    return lp_accum__.sum();
  }
  template <typename RNG, typename VecR, typename VecI, typename VecVar,
            stan::require_vector_like_vt<std::is_floating_point,
            VecR>* = nullptr, stan::require_vector_like_vt<std::is_integral,
            VecI>* = nullptr, stan::require_vector_vt<std::is_floating_point,
            VecVar>* = nullptr>
  inline void
  write_array_impl(RNG& base_rng__, VecR& params_r__, VecI& params_i__,
                   VecVar& vars__, const bool
                   emit_transformed_parameters__ = true, const bool
                   emit_generated_quantities__ = true, std::ostream*
                   pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    stan::io::deserializer<local_scalar_t__> in__(params_r__, params_i__);
    stan::io::serializer<local_scalar_t__> out__(vars__);
    static constexpr bool propto__ = true;
    // suppress unused var warning
    (void) propto__;
    double lp__ = 0.0;
    // suppress unused var warning
    (void) lp__;
    int current_statement__ = 0;
    stan::math::accumulator<double> lp_accum__;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    // suppress unused var warning
    (void) DUMMY_VAR__;
    constexpr bool jacobian__ = false;
    static constexpr const char* function__ =
      "model_NB_namespace::write_array";
    // suppress unused var warning
    (void) function__;
    try {
      double alpha = std::numeric_limits<double>::quiet_NaN();
      current_statement__ = 1;
      alpha = in__.template read<local_scalar_t__>();
      Eigen::Matrix<double,-1,1> beta =
        Eigen::Matrix<double,-1,1>::Constant(K,
          std::numeric_limits<double>::quiet_NaN());
      current_statement__ = 2;
      beta = in__.template read<Eigen::Matrix<local_scalar_t__,-1,1>>(K);
      double log_phi = std::numeric_limits<double>::quiet_NaN();
      current_statement__ = 3;
      log_phi = in__.template read<local_scalar_t__>();
      double tau = std::numeric_limits<double>::quiet_NaN();
      current_statement__ = 4;
      tau = in__.template read<local_scalar_t__>();
      double phi = std::numeric_limits<double>::quiet_NaN();
      out__.write(alpha);
      out__.write(beta);
      out__.write(log_phi);
      out__.write(tau);
      if (stan::math::logical_negation(
            (stan::math::primitive_value(emit_transformed_parameters__) ||
            stan::math::primitive_value(emit_generated_quantities__)))) {
        return ;
      }
      current_statement__ = 5;
      phi = stan::math::exp(log_phi);
      if (emit_transformed_parameters__) {
        out__.write(phi);
      }
      if (stan::math::logical_negation(emit_generated_quantities__)) {
        return ;
      }
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
    }
  }
  template <typename VecVar, typename VecI,
            stan::require_vector_t<VecVar>* = nullptr,
            stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr>
  inline void
  unconstrain_array_impl(const VecVar& params_r__, const VecI& params_i__,
                         VecVar& vars__, std::ostream* pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    stan::io::deserializer<local_scalar_t__> in__(params_r__, params_i__);
    stan::io::serializer<local_scalar_t__> out__(vars__);
    int current_statement__ = 0;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    // suppress unused var warning
    (void) DUMMY_VAR__;
    try {
      int pos__ = std::numeric_limits<int>::min();
      pos__ = 1;
      local_scalar_t__ alpha = DUMMY_VAR__;
      current_statement__ = 1;
      alpha = in__.read<local_scalar_t__>();
      out__.write(alpha);
      Eigen::Matrix<local_scalar_t__,-1,1> beta =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(K, DUMMY_VAR__);
      current_statement__ = 2;
      stan::model::assign(beta,
        in__.read<Eigen::Matrix<local_scalar_t__,-1,1>>(K),
        "assigning variable beta");
      out__.write(beta);
      local_scalar_t__ log_phi = DUMMY_VAR__;
      current_statement__ = 3;
      log_phi = in__.read<local_scalar_t__>();
      out__.write(log_phi);
      local_scalar_t__ tau = DUMMY_VAR__;
      current_statement__ = 4;
      tau = in__.read<local_scalar_t__>();
      out__.write(tau);
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
    }
  }
  template <typename VecVar, stan::require_vector_t<VecVar>* = nullptr>
  inline void
  transform_inits_impl(const stan::io::var_context& context__, VecVar&
                       vars__, std::ostream* pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    stan::io::serializer<local_scalar_t__> out__(vars__);
    int current_statement__ = 0;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    // suppress unused var warning
    (void) DUMMY_VAR__;
    try {
      current_statement__ = 1;
      context__.validate_dims("parameter initialization", "alpha", "double",
        std::vector<size_t>{});
      current_statement__ = 2;
      context__.validate_dims("parameter initialization", "beta", "double",
        std::vector<size_t>{static_cast<size_t>(K)});
      current_statement__ = 3;
      context__.validate_dims("parameter initialization", "log_phi",
        "double", std::vector<size_t>{});
      current_statement__ = 4;
      context__.validate_dims("parameter initialization", "tau", "double",
        std::vector<size_t>{});
      int pos__ = std::numeric_limits<int>::min();
      pos__ = 1;
      local_scalar_t__ alpha = DUMMY_VAR__;
      current_statement__ = 1;
      alpha = context__.vals_r("alpha")[(1 - 1)];
      out__.write(alpha);
      Eigen::Matrix<local_scalar_t__,-1,1> beta =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(K, DUMMY_VAR__);
      {
        std::vector<local_scalar_t__> beta_flat__;
        current_statement__ = 2;
        beta_flat__ = context__.vals_r("beta");
        current_statement__ = 2;
        pos__ = 1;
        current_statement__ = 2;
        for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
          current_statement__ = 2;
          stan::model::assign(beta, beta_flat__[(pos__ - 1)],
            "assigning variable beta", stan::model::index_uni(sym1__));
          current_statement__ = 2;
          pos__ = (pos__ + 1);
        }
      }
      out__.write(beta);
      local_scalar_t__ log_phi = DUMMY_VAR__;
      current_statement__ = 3;
      log_phi = context__.vals_r("log_phi")[(1 - 1)];
      out__.write(log_phi);
      local_scalar_t__ tau = DUMMY_VAR__;
      current_statement__ = 4;
      tau = context__.vals_r("tau")[(1 - 1)];
      out__.write(tau);
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
    }
  }
  inline void
  get_param_names(std::vector<std::string>& names__, const bool
                  emit_transformed_parameters__ = true, const bool
                  emit_generated_quantities__ = true) const {
    names__ = std::vector<std::string>{"alpha", "beta", "log_phi", "tau"};
    if (emit_transformed_parameters__) {
      std::vector<std::string> temp{"phi"};
      names__.reserve(names__.size() + temp.size());
      names__.insert(names__.end(), temp.begin(), temp.end());
    }
    if (emit_generated_quantities__) {}
  }
  inline void
  get_dims(std::vector<std::vector<size_t>>& dimss__, const bool
           emit_transformed_parameters__ = true, const bool
           emit_generated_quantities__ = true) const {
    dimss__ = std::vector<std::vector<size_t>>{std::vector<size_t>{},
                std::vector<size_t>{static_cast<size_t>(K)},
                std::vector<size_t>{}, std::vector<size_t>{}};
    if (emit_transformed_parameters__) {
      std::vector<std::vector<size_t>> temp{std::vector<size_t>{}};
      dimss__.reserve(dimss__.size() + temp.size());
      dimss__.insert(dimss__.end(), temp.begin(), temp.end());
    }
    if (emit_generated_quantities__) {}
  }
  inline void
  constrained_param_names(std::vector<std::string>& param_names__, bool
                          emit_transformed_parameters__ = true, bool
                          emit_generated_quantities__ = true) const final {
    param_names__.emplace_back(std::string() + "alpha");
    for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
      param_names__.emplace_back(std::string() + "beta" + '.' +
        std::to_string(sym1__));
    }
    param_names__.emplace_back(std::string() + "log_phi");
    param_names__.emplace_back(std::string() + "tau");
    if (emit_transformed_parameters__) {
      param_names__.emplace_back(std::string() + "phi");
    }
    if (emit_generated_quantities__) {}
  }
  inline void
  unconstrained_param_names(std::vector<std::string>& param_names__, bool
                            emit_transformed_parameters__ = true, bool
                            emit_generated_quantities__ = true) const final {
    param_names__.emplace_back(std::string() + "alpha");
    for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
      param_names__.emplace_back(std::string() + "beta" + '.' +
        std::to_string(sym1__));
    }
    param_names__.emplace_back(std::string() + "log_phi");
    param_names__.emplace_back(std::string() + "tau");
    if (emit_transformed_parameters__) {
      param_names__.emplace_back(std::string() + "phi");
    }
    if (emit_generated_quantities__) {}
  }
  inline std::string get_constrained_sizedtypes() const {
    return std::string("[{\"name\":\"alpha\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"beta\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(K) + "},\"block\":\"parameters\"},{\"name\":\"log_phi\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"tau\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"phi\",\"type\":{\"name\":\"real\"},\"block\":\"transformed_parameters\"}]");
  }
  inline std::string get_unconstrained_sizedtypes() const {
    return std::string("[{\"name\":\"alpha\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"beta\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(K) + "},\"block\":\"parameters\"},{\"name\":\"log_phi\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"tau\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"phi\",\"type\":{\"name\":\"real\"},\"block\":\"transformed_parameters\"}]");
  }
  // Begin method overload boilerplate
  template <typename RNG> inline void
  write_array(RNG& base_rng, Eigen::Matrix<double,-1,1>& params_r,
              Eigen::Matrix<double,-1,1>& vars, const bool
              emit_transformed_parameters = true, const bool
              emit_generated_quantities = true, std::ostream*
              pstream = nullptr) const {
    const size_t num_params__ = (((1 + K) + 1) + 1);
    const size_t num_transformed = emit_transformed_parameters * (1);
    const size_t num_gen_quantities = emit_generated_quantities * (0);
    const size_t num_to_write = num_params__ + num_transformed +
      num_gen_quantities;
    std::vector<int> params_i;
    vars = Eigen::Matrix<double,-1,1>::Constant(num_to_write,
             std::numeric_limits<double>::quiet_NaN());
    write_array_impl(base_rng, params_r, params_i, vars,
      emit_transformed_parameters, emit_generated_quantities, pstream);
  }
  template <typename RNG> inline void
  write_array(RNG& base_rng, std::vector<double>& params_r, std::vector<int>&
              params_i, std::vector<double>& vars, bool
              emit_transformed_parameters = true, bool
              emit_generated_quantities = true, std::ostream*
              pstream = nullptr) const {
    const size_t num_params__ = (((1 + K) + 1) + 1);
    const size_t num_transformed = emit_transformed_parameters * (1);
    const size_t num_gen_quantities = emit_generated_quantities * (0);
    const size_t num_to_write = num_params__ + num_transformed +
      num_gen_quantities;
    vars = std::vector<double>(num_to_write,
             std::numeric_limits<double>::quiet_NaN());
    write_array_impl(base_rng, params_r, params_i, vars,
      emit_transformed_parameters, emit_generated_quantities, pstream);
  }
  template <bool propto__, bool jacobian__, typename T_> inline T_
  log_prob(Eigen::Matrix<T_,-1,1>& params_r, std::ostream* pstream = nullptr) const {
    Eigen::Matrix<int,-1,1> params_i;
    return log_prob_impl<propto__, jacobian__>(params_r, params_i, pstream);
  }
  template <bool propto__, bool jacobian__, typename T_> inline T_
  log_prob(std::vector<T_>& params_r, std::vector<int>& params_i,
           std::ostream* pstream = nullptr) const {
    return log_prob_impl<propto__, jacobian__>(params_r, params_i, pstream);
  }
  inline void
  transform_inits(const stan::io::var_context& context,
                  Eigen::Matrix<double,-1,1>& params_r, std::ostream*
                  pstream = nullptr) const final {
    std::vector<double> params_r_vec(params_r.size());
    std::vector<int> params_i;
    transform_inits(context, params_i, params_r_vec, pstream);
    params_r = Eigen::Map<Eigen::Matrix<double,-1,1>>(params_r_vec.data(),
                 params_r_vec.size());
  }
  inline void
  transform_inits(const stan::io::var_context& context, std::vector<int>&
                  params_i, std::vector<double>& vars, std::ostream*
                  pstream__ = nullptr) const {
    vars.resize(num_params_r__);
    transform_inits_impl(context, vars, pstream__);
  }
  inline void
  unconstrain_array(const std::vector<double>& params_constrained,
                    std::vector<double>& params_unconstrained, std::ostream*
                    pstream = nullptr) const {
    const std::vector<int> params_i;
    params_unconstrained = std::vector<double>(num_params_r__,
                             std::numeric_limits<double>::quiet_NaN());
    unconstrain_array_impl(params_constrained, params_i,
      params_unconstrained, pstream);
  }
  inline void
  unconstrain_array(const Eigen::Matrix<double,-1,1>& params_constrained,
                    Eigen::Matrix<double,-1,1>& params_unconstrained,
                    std::ostream* pstream = nullptr) const {
    const std::vector<int> params_i;
    params_unconstrained = Eigen::Matrix<double,-1,1>::Constant(num_params_r__,
                             std::numeric_limits<double>::quiet_NaN());
    unconstrain_array_impl(params_constrained, params_i,
      params_unconstrained, pstream);
  }
};
}
using stan_model = model_NB_namespace::model_NB;
#ifndef USING_R
// Boilerplate
stan::model::model_base&
new_model(stan::io::var_context& data_context, unsigned int seed,
          std::ostream* msg_stream) {
  stan_model* m = new stan_model(data_context, seed, msg_stream);
  return *m;
}
stan::math::profile_map& get_stan_profile_data() {
  return model_NB_namespace::profiles__;
}
#endif
#endif
