% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metaAnalysis.R
\name{metaAnalysis}
\alias{metaAnalysis}
\title{Create a Meta-Analysis Object Using Data From Previous Studies}
\description{
Create a Meta-Analysis Object Using Data From Previous Studies

Create a Meta-Analysis Object Using Data From Previous Studies
}
\details{
A meta analysis has raw data and draws from the lift's posterior
distribution. This is represented by an R6 Class.
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{PosteriorATE}}{Draws from the posterior distribution of the
average treatment effect.}

\item{\code{checks}}{MCMC diagnostics}

\item{\code{CredibleInterval}}{Lower and upper bounds of the credible interval}

\item{\code{PointEstimate}}{Point estimate of the average treatment effect}

\item{\code{fitted}}{Stan fit object}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-meta-analysis-new}{\code{metaAnalysis$new()}}
\item \href{#method-meta-analysis-PlotRawData}{\code{metaAnalysis$PlotRawData()}}
\item \href{#method-meta-analysis-PlotLift}{\code{metaAnalysis$PlotLift()}}
\item \href{#method-meta-analysis-UpdateCI}{\code{metaAnalysis$UpdateCI()}}
\item \href{#method-meta-analysis-probability}{\code{metaAnalysis$probability()}}
\item \href{#method-meta-analysis-findings}{\code{metaAnalysis$findings()}}
\item \href{#method-meta-analysis-clone}{\code{metaAnalysis$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-meta-analysis-new"></a>}}
\if{latex}{\out{\hypertarget{method-meta-analysis-new}{}}}
\subsection{Method \code{new()}}{
Create a new meta analysis object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{metaAnalysis$new(
  data,
  point_estimates,
  standard_errors,
  id,
  mean_mu = 0,
  sd_mu = 0.05,
  ci_width = 0.75,
  X = NULL,
  run_estimation = 1,
  ...
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{data}}{Data frame with data point estimates and standard
errors from studies.}

\item{\code{point_estimates}}{Name of the variable in the data frame that
contains the point estimates.}

\item{\code{standard_errors}}{Name of the variable in the data frame that
contains the standard errors of the point estimates.}

\item{\code{id}}{Name of the variable in the data frame that contains the
id of the studies.}

\item{\code{mean_mu}}{Prior mean for the true lift in the population.}

\item{\code{sd_mu}}{Prior mean for the standard deviation of the
true lift in the population.}

\item{\code{ci_width}}{Credible interval's width.}

\item{\code{X}}{Covariates matrix.}

\item{\code{run_estimation}}{Integer flag to control whether estimation is run (1) or not (0).}

\item{\code{...}}{other arguments passed to \code{\link[rstan:stanmodel-method-sampling]{rstan::sampling()}}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new \code{meta_analysis} object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-meta-analysis-PlotRawData"></a>}}
\if{latex}{\out{\hypertarget{method-meta-analysis-PlotRawData}{}}}
\subsection{Method \code{PlotRawData()}}{
Plots the raw data.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{metaAnalysis$PlotRawData()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A plot with point estimates and 95\% confidence intervals.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-meta-analysis-PlotLift"></a>}}
\if{latex}{\out{\hypertarget{method-meta-analysis-PlotLift}{}}}
\subsection{Method \code{PlotLift()}}{
Plots lift's prior and posterior distributions.

For more details see \code{\link[vizdraws:vizdraws]{vizdraws::vizdraws()}}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{metaAnalysis$PlotLift(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{other arguments passed to vizdraws.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
An interactive plot of the prior and posterior distributions.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-meta-analysis-UpdateCI"></a>}}
\if{latex}{\out{\hypertarget{method-meta-analysis-UpdateCI}{}}}
\subsection{Method \code{UpdateCI()}}{
Update the width of the credible interval.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{metaAnalysis$UpdateCI(ci_width)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{ci_width}}{New width for the credible interval. This number in the
(0,1) interval.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-meta-analysis-probability"></a>}}
\if{latex}{\out{\hypertarget{method-meta-analysis-probability}{}}}
\subsection{Method \code{probability()}}{
Calculates that probability that lift is between a and b.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{metaAnalysis$probability(a = -Inf, b = Inf, percent = TRUE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{a}}{Lower bound. By default -Inf.}

\item{\code{b}}{Upper bound. By default Inf.}

\item{\code{percent}}{A logical that indicates that a and b should
be converted to percentage.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A string with the probability.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-meta-analysis-findings"></a>}}
\if{latex}{\out{\hypertarget{method-meta-analysis-findings}{}}}
\subsection{Method \code{findings()}}{
Calculates the point estimate a credible interval for the meta analysis.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{metaAnalysis$findings(percent = TRUE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{percent}}{A logical that indicates that the point estimate should be
converted to percent.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A string with the findings
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-meta-analysis-clone"></a>}}
\if{latex}{\out{\hypertarget{method-meta-analysis-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{metaAnalysis$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
