% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checkBaseline.R
\name{hedgesG}
\alias{hedgesG}
\title{Hedges' g Effect Size with Pooled Standard Deviation}
\usage{
hedgesG(n_t, n_c, y_t, y_c, s_t, s_c)
}
\arguments{
\item{n_t}{Numeric value representing the sample size of the treatment group.}

\item{n_c}{Numeric value representing the sample size of the control group.}

\item{y_t}{Numeric value representing the mean of the treatment group.}

\item{y_c}{Numeric value representing the mean of the control group.}

\item{s_t}{Numeric value representing the standard deviation of the treatment group.}

\item{s_c}{Numeric value representing the standard deviation of the control group.}
}
\value{
The calculated Hedges' g effect size.
}
\description{
Calculates Hedges' g, a standardized effect size for comparing means.
This version includes a small-sample correction factor (omega)
and uses the pooled standard deviation.
}
\details{
Hedges' g is a variation of Cohen's d that adjusts for small-sample bias.
It is calculated as the difference in means divided by the pooled standard
deviation, then multiplied by a correction factor.
}
\references{
Hedges, L. V. (1981). Distribution theory for Glass's estimator of effect size and related estimators.
Journal of Educational Statistics, 6(2), 107-128.
}
