% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checkBaseline.R
\name{coxsIndex}
\alias{coxsIndex}
\title{Cox's Proportional Hazards Index (Cox's C)}
\usage{
coxsIndex(p_t, p_c, n_t, n_c)
}
\arguments{
\item{p_t}{Numeric value representing the proportion of events (e.g., failures, deaths) in the treatment group.}

\item{p_c}{Numeric value representing the proportion of events in the control group.}

\item{n_t}{Numeric value representing the sample size of the treatment group.}

\item{n_c}{Numeric value representing the sample size of the control group.}
}
\value{
The calculated Cox's C effect size.
}
\description{
Calculates Cox's C, a standardized effect size measure for comparing hazard rates
between two groups in survival analysis.
}
\details{
Cox's C is a useful effect size for survival analysis when hazard ratios are not constant over time.
It's calculated based on the log odds ratio of events and includes a small sample size correction.
The value 1.65 is used to approximate a conversion to a Cohen's d-like scale.
}
\references{
Cox, D. R. (1972). Regression models and life-tables. Journal of the Royal Statistical Society: Series B (Methodological), 34(2), 187-202.
}
