% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper.R
\name{calcProb}
\alias{calcProb}
\title{Calculate Probability of Posterior Draws Falling Within a Range}
\usage{
calcProb(x, a = NULL, b = NULL, prior = FALSE, group_name = "group average")
}
\arguments{
\item{x}{A numeric vector containing either posterior draws (default)
or prior samples of the treatment effect parameter (\code{eta}).}

\item{a}{(Optional) The lower bound of the range (as a proportion, not percentage).}

\item{b}{(Optional) The upper bound of the range (as a proportion, not percentage).}

\item{prior}{A logical value indicating whether to use prior samples (\code{TRUE})
or posterior draws (\code{FALSE}, default) for calculation.}

\item{group_name}{A string describing the group for which the probability
is being calculated (default: "group average").}
}
\value{
A formatted string stating the calculated probability and the
specified range. The probability is the proportion of samples
(either prior or posterior) that fall within the defined range.
}
\description{
This function estimates the probability that a vector of posterior draws,
represented by the parameter \code{eta}, falls within a specified range.
It provides flexibility to use either prior distributions or posterior draws,
and to specify one-sided or two-sided probability calculations.
}
\details{
This function checks the following cases:
\itemize{
\item If both \code{a} and \code{b} are \code{NULL}, it returns an empty string.
\item If \code{b} is less than or equal to \code{a}, it throws an error.
}

The calculated probability and range are presented in a human-readable string
using the \code{glue} package for formatting.
}
