% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DoItALL.R
\name{calc_all}
\alias{calc_all}
\title{Calculate and Impute REE missing data and anomalies.}
\usage{
calc_all(dat, prefix = NULL, suffix = NULL, chondrite = PalmeOneill2014CI)
}
\arguments{
\item{dat}{A data frame with REE data in ppm}

\item{prefix}{A prefix in your columns e.g. ICP_La}

\item{suffix}{A suffix in your columns e.g. La_ppm}

\item{chondrite}{an option from: PalmeOneill2014CI, Oneill2014Mantle, McDonough1995CI}
}
\value{
A data frame. Includes imputed REE, model metrics, and calculated variables.
}
\description{
This is a wrapper for \code{data \%>\% model_REE() \%>\% impute_REE() \%>\% add_parameters()}
}
\examples{

Ballard_et_al_Zircon \%>\% calc_all(prefix = 'Zr_', suffix = '_ppm')


}
