% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{specify_parameters}
\alias{specify_parameters}
\title{Specify prediction model parameters}
\usage{
specify_parameters(data, acc_placement, subj_body_mass)
}
\arguments{
\item{data}{An \code{impactr_data} object, as obtained with
\link[=read_acc]{read_acc()}.}

\item{acc_placement}{A character string indicating the accelerometer
placement. Can be either "ankle", "back", or "hip".}

\item{subj_body_mass}{A double scalar indicating the subject body mass
in kilograms.}
}
\value{
An object of class \code{impactr_data} with the specified parameters
as attributes.
}
\description{
Specify the accelerometer placement used and the subject body mass. These
data is needed in order to use the mechanical loading prediction models.
}
\examples{
data <- read_acc(impactr_example("hip-raw.csv"))
specify_parameters(data, acc_placement = "hip", subj_body_mass = 79.2)
}
