% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim.R
\name{sim_reference}
\alias{sim_reference}
\title{Simulate an ideal population}
\usage{
sim_reference(
  init_pop_size,
  vaccinations,
  cases_novac,
  ve,
  lag,
  deterministic,
  seed = sample.int(.Machine$integer.max, 1)
)
}
\arguments{
\item{init_pop_size}{Integer initial population size}

\item{vaccinations}{Integer vector number of vaccinations at every timepoint}

\item{cases_novac}{Integer vector number of cases at every timepoint}

\item{ve}{Vaccine effectiveness (proportion)}

\item{lag}{Integer lag period measured in timepoints}

\item{deterministic}{Boolean whether to make the simulation deterministic}

\item{seed}{Integer seed to use}
}
\value{
A \link[tibble]{tibble} with the following columns:
  \item{timepoint}{Index of timepoint}
  \item{vaccinations}{Expected number of vaccinations}
  \item{cases_novac}{Expected number of cases in absence of vaccination}
  \item{ve}{Expected vaccine effectiveness}
  \item{pflu}{Flu incidence}
  \item{cases}{Actual number of cases}
  \item{popn}{Non-cases in absence of vaccination}
  \item{pvac}{Proportion of starting population vaccinated}
  \item{b}{Number vaccinated at that time}
  \item{A}{Non-vaccinated non-cases}
  \item{B}{Vaccinated non-cases lagging}
  \item{E}{Non-vaccinated cases}
}
\description{
Simulates an ideal population using the reference model from Tokars (2018).
}
\examples{
# Population from Tokars (2018)
nsam <- 1e6L
ndays <- 304L
pop_tok <- sim_reference(
  init_pop_size = nsam,
  vaccinations = generate_counts(nsam, ndays, 0.55, mean = 100, sd = 50),
  cases_novac = generate_counts(nsam, ndays, 0.12, mean = 190, sd = 35),
  ve = 0.48,
  lag = 14,
  deterministic = TRUE
)
head(pop_tok)
sum(pop_tok$avert)
}
\references{
Tokars JI, Rolfes MA, Foppa IM, Reed C. An evaluation and update
  of methods for estimating the number of influenza cases averted by
  vaccination in the United States. Vaccine. 2018;36(48):7331–7337.
  doi:10.1016/j.vaccine.2018.10.026
}
