% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/v1_public_airr.R
\name{airr_public}
\alias{airr_public}
\alias{airr_public_intersection}
\alias{airr_public_jaccard}
\title{Public indices - pairwise repertoire overlap}
\usage{
airr_public_intersection(
  idata,
  autojoin = getOption("immundata.autojoin", TRUE),
  format = c("long", "wide")
)

airr_public_jaccard(
  idata,
  autojoin = getOption("immundata.autojoin", TRUE),
  format = c("long", "wide")
)
}
\arguments{
\item{idata}{An \code{ImmunData} object.}

\item{autojoin}{Logical. If TRUE, join repertoire metadata by the schema repertoire id.
Change the default behaviour by calling \code{options(immunarch.autojoin = FALSE)}.}

\item{format}{String. One of \code{"long"} ("long" tibble with \code{imd_repertoire_id}, facet
columns, and \code{value}; useful for visualizations) or \code{"wide"} (wide/unmelted table of features,
with each row corresponding to a specific repertoire / pair of repertoires; useful for Machine Learning).}
}
\value{
\subsection{\code{airr_public_intersection}}{

A \strong{symmetric numeric matrix} where rows/columns are \code{repertoire_id} and each
cell is the count of shared unique receptors. The diagonal contains per-repertoire
richness (total unique receptors). Row/column names are repertoire IDs.
}

\subsection{\code{airr_public_jaccard}}{

A \strong{symmetric numeric matrix} where rows/columns are \code{repertoire_id} and each
cell is the Jaccard similarity in \verb{[0, 1]}. The diagonal is \code{1}. Row/column
names are repertoire IDs.
}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

A family of functions to quantify \strong{public or shared receptors} between repertoire.
\subsection{Available functions}{

Supported methods are the following.
}

\code{airr_public_intersection} - number of \strong{shared receptors} between
each pair of repertoires (intersection size). Handy for quick overlap heatmaps,
QC of replicate similarity, or spotting donor-shared "public" clonotypes.

\code{airr_public_jaccard} - \strong{Jaccard similarity} of receptor
sets between repertoires (\eqn{A \cap B}{A cap B} / \eqn{A \cup B}{A cup B}). Best when comparing cohorts with
different sizes to get a scale-invariant overlap score.
}
\examples{
# Limit the number of threads used by the underlying DB for this session.
# Change this only if you know what you're doing (e.g., multi-user machines, shared CI/servers).
db_exec("SET threads TO 1")
# Load data
immdata <- get_test_idata() |> agg_repertoires("Therapy")

#
# airr_public_intersection
#
\dontrun{
m_pub <- airr_public_intersection(immdata)
}

#
# airr_public_jaccard
#
\dontrun{
m_jac <- airr_public_jaccard(immdata)
}

}
\seealso{
\link[immundata:ImmunData]{immundata::ImmunData}
}
\concept{Public indices}
