% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{plotComparison}
\alias{plotComparison}
\title{Plots comparison between the original and the new balanced dataset.}
\usage{
plotComparison(dataset, anotherDataset, attrs, cols = 2, classAttr = "Class")
}
\arguments{
\item{dataset}{A \code{data.frame}. The former imbalanced dataset.}

\item{anotherDataset}{A \code{data.frame}. The balanced dataset.
\code{dataset} and \code{anotherDataset} must have the same columns.}

\item{attrs}{Vector of \code{character}. Attributes to compare. The function
generates each posible combination of attributes to build the comparison.}

\item{cols}{Integer. It indicates the number of columns of resulting grid.
Must be an even number. By default, 2.}

\item{classAttr}{\code{character}. Indicates the class attribute from
\code{dataset}. Must exist in it.}
}
\value{
Plot of 2D comparison between the variables.
}
\description{
It plots a grid of one to one variable comparison, placing the former dataset
graphics next to the balanced one, for each pair of attributes.
}
\examples{
data(iris0)
set.seed(12345)

rwoSamples <- rwo(iris0, numInstances = 100)
rwoBalanced <- rbind(iris0, rwoSamples)
plotComparison(iris0, rwoBalanced, names(iris0), cols = 2, classAttr = "Class")

}
