% Generated by roxygen2: do not edit by hand
% Please edit documentation in
%   R/adaptive_double_plateaus_histogram_equalization.R
\name{EqualizeDP}
\alias{EqualizeDP}
\title{Double Plateaus Histogram Equalization}
\usage{
EqualizeDP(im, t_down, t_up, N = 1000, range = c(0, 255))
}
\arguments{
\item{im}{a grayscale image of class cimg}

\item{t_down}{lower threshold}

\item{t_up}{upper threshold}

\item{N}{the number of subintervals of histogram}

\item{range}{range of the pixel values of image. this function assumes that the range of pixel values of of an input image is [0,255] by default. you may prefer [0,1].}
}
\value{
a grayscale image of class cimg
}
\description{
enhance contrast of image by double plateaus histogram equalization.
}
\examples{
g <- grayscale(dogs)
layout(matrix(1:2, 1, 2))
plot(g, main = "Original")
EqualizeDP(g, 20, 186) \%>\% plot(main = "Contrast Enhanced")
}
\references{
Kun Liang, Yong Ma, Yue Xie, Bo Zhou ,Rui Wang (2012). A new adaptive contrast enhancement algorithm for infrared images based on double plateaus histogram equalization. Infrared Phys. Technol. 55, 309-315.
}
\author{
Shota Ochi
}
