% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mad_glu.r
\name{mad_glu}
\alias{mad_glu}
\title{Calculate Median Absolute Deviation (MAD)}
\usage{
mad_glu(data, constant = 1.4826)
}
\arguments{
\item{data}{DataFrame object with column names "id", "time", and "gl",
or numeric vector of glucose values.}

\item{constant}{Numeric object which will be multipled by the MAD value. Defaults to 1.4826.
Reasons for this default value can be seen in the details section of the documentation of r's base mad method}
}
\value{
If a data.frame object is passed, then a tibble object with
two columns: subject id and corresponding MAD value is returned. If a vector of glucose
values is passed, then a tibble object with just the MAD value is returned.
as.numeric() can be wrapped around the latter to output just a numeric value.
}
\description{
The function mad produces MAD values in a tibble object.
}
\details{
A tibble object with 1 row for each subject, a column for subject id and
a column for MAD values is returned. NA glucose values are
omitted from the calculation of the MAD.

MAD is calculated by taking the median of the difference of the
glucose readings from their median and multiplying it by a scaling factor
\eqn{1.4826*median(|gl-median(gl)|)}, where gl is the list of Glucose measurements.
}
\examples{

data(example_data_1_subject)
mad_glu(example_data_1_subject)

data(example_data_5_subject)
mad_glu(example_data_5_subject)

}
\author{
David Buchanan, Marielle Hicban
}
