% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{example_data_hall}
\alias{example_data_hall}
\title{Example data from Hall et al. (2018)}
\format{
a data.frame with 34890 rows and 4 columns, which are:
\describe{
\item{id}{identifier of subject}
\item{time}{date and time stamp}
\item{gl}{glucose level as measured by CGM (mg/dL)}
\item{diagnosis}{character indicating diabetes diagnosis: diabetic or pre-diabetic}
}
}
\usage{
example_data_hall
}
\description{
Dexcom G4 CGM measurements for 19 subjects from the Hall
publicly available dataset. Chosen as a subset of all subjects to be only those
with diabetes or pre-diabetes. Primarily intended for use with example_meals_hall
}
\details{
This dataset can be used along with the example_meals_hall dataset in this package
to calculate meal_metrics.
}
\references{
Hall et al. (2018) : Glucotypes reveal new patterns of glucose dysregulation
\emph{Plos Biology} \strong{16} (7): 3:e2005143
\doi{10.1371/journal.pbio.2005143}.
}
\keyword{datasets}
