\name{simu.idr}
\alias{simu.idr}
\docType{data}
\title{
Simulated data
}
\description{
  This is a simulated dataset for testing the program. Data is first
  simulated from the copula mixture model with latent structure of 0.65
  N(mu, mu, sigma, sigma, rho) + 0.95 N(0, 0, 1, 1, 0), where mu=2.5,
  sigma=1, rho=0.84. The observations
  in the dataset are then generated by taking the p-values from a z-test H0:
  mu=0.     
%%  ~~ A concise (1-5 lines) description of the dataset. ~~
}
\usage{data(simu.idr)}
\format{
  A data frame with 1000 observations on the following 3 variables.
  \describe{
    \item{\code{x}}{a numeric vector, representing p-values on replicate
    1}
    \item{\code{y}}{a numeric vector, representing p-values on replicate
    2}
    \item{\code{labels}}{a binary vector, where 1 represents the
      reproducible component and 0 represents the irreproducible component. }
  }
}
%\details{
%%  ~~ If necessary, more details than the __description__ above ~~
%}
%\source{
%%  ~~ reference to a publication or URL from which the data were obtained ~~
%}
\references{
  Q. Li, J. B. Brown, H. Huang and P. J. Bickel. (2011)
   Measuring reproducibility of high-throughput experiments. Annals of Applied Statistics, Vol. 5, No. 3, 1752-1779.
%%  ~~ possibly secondary sources and usages ~~
}
\examples{
data(simu.idr)
plot(rank(simu.idr$x), rank(simu.idr$y)) 
}
\keyword{datasets}
