% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lambdaG.R
\name{lambdaG}
\alias{lambdaG}
\title{Apply the LambdaG algorithm}
\usage{
lambdaG(q.data, k.data, ref.data, N = 10, r = 30, cores = NULL)
}
\arguments{
\item{q.data}{The questioned or disputed data as a \code{quanteda} tokens object with the tokens being sentences (e.g. the output of \code{\link[=tokenize_sents]{tokenize_sents()}}).}

\item{k.data}{The known or undisputed data as a \code{quanteda} tokens object with the tokens being sentences (e.g. the output of \code{\link[=tokenize_sents]{tokenize_sents()}}).}

\item{ref.data}{The reference dataset as a \code{quanteda} tokens object with the tokens being sentences (e.g. the output of \code{\link[=tokenize_sents]{tokenize_sents()}}). This can be the same object as \code{k.data}.}

\item{N}{The order of the model. Default is 10.}

\item{r}{The number of iterations. Default is 30.}

\item{cores}{The number of cores to use for parallel processing (the default is one).}
}
\value{
The function will test all possible combinations of Q texts and candidate authors and return a
data frame containing \eqn{\lambda_G}, an uncalibrated log-likelihood ratio (base 10). \eqn{\lambda_G} can then be calibrated into a likelihood ratio that expresses the strength of the evidence using \code{\link[=calibrate_LLR]{calibrate_LLR()}}. The data frame contains a column called "target" with a logical value which is TRUE if the author of the Q text is the candidate and FALSE otherwise.
}
\description{
This function calculates the likelihood ratio of grammar models, or \eqn{\lambda_G}, as in Nini et al. (under review). In order to run the analysis as in this paper, all data must be preprocessed using \code{\link[=contentmask]{contentmask()}} with the "algorithm" parameter set to "POSnoise".
}
\examples{
q.data <- enron.sample[1] |> quanteda::tokens("sentence")
k.data <- enron.sample[2:10] |> quanteda::tokens("sentence")
ref.data <- enron.sample[11:ndoc(enron.sample)] |> quanteda::tokens("sentence")
lambdaG(q.data, k.data, ref.data)

}
\references{
Nini, A., Halvani, O., Graner, L., Gherardi, V., Ishihara, S. Authorship Verification based on the Likelihood Ratio of Grammar Models. https://arxiv.org/abs/2403.08462v1
}
