% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iqv.R
\name{iqv}
\alias{iqv}
\title{Agresti's Index of Qualitative Variation (\code{iqv})}
\usage{
iqv(ego_id, measure, prefix = NULL, suffix = NULL)
}
\arguments{
\item{ego_id}{A vector of ego identifiers located in an alter dataframe. If using data objects created by \code{ego_netwrite}, this should be the data frame entitled \code{alters}.}

\item{measure}{A vector of alter attributes for a given categorical measure.}

\item{prefix}{A character value indicating the desired prefix for the calculated homophily measure.}

\item{suffix}{A character value indicating the desired suffix for the calculated homophily measure.}
}
\value{
\code{iqv} returns a dataframe of vectors that include the ego identifier and iqv value of diversity for the desired categorical attribute.
}
\description{
A normalized value of the h-index for measuring the diversity of an ego's network for categorical attributes (Perry et al. 2018)
}
\examples{

# Run `ego_netwrite`
ngq_nw <- ego_netwrite(egos = ngq_egos,
                      ego_id = ngq_egos$ego_id,

                      alters = ngq_alters,
                      alter_id = ngq_alters$alter_id,
                      alter_ego = ngq_alters$ego_id,

                      max_alters = 10,
                      alter_alter = ngq_aa,
                      aa_ego = ngq_aa$ego_id,
                      i_elements = ngq_aa$alter1,
                      j_elements = ngq_aa$alter2,
                      directed = FALSE)


# Get IQV for sex
sex_iqv <- iqv(ego_id = ngq_nw$alters$ego_id,
              measure = ngq_nw$alters$sex,
              prefix = "sex")

sex_iqv
}
