% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rasterplot.R
\name{rasterplot}
\alias{rasterplot}
\title{Plot probabilities as a raster`}
\usage{
rasterplot(
  icf,
  type = c("both", "R", "Y"),
  sel = NULL,
  label = NULL,
  show_label = FALSE,
  pow = 0.2,
  order = TRUE,
  do_plot = TRUE
)
}
\arguments{
\item{icf}{an object of class 'icfit'}

\item{type}{a string giving the type of the plot. Accepted choices: 'R' (risk probabilities) and 'Y' (event probabilities)}

\item{sel}{a vector of integers for selection of subject (rows of the matrix)}

\item{label}{character vector containing labels for the individuals to be plotted in selection}

\item{show_label}{Boolean, whether or not to show the labels}

\item{pow}{a number, giving he power to which the probabilities will be raised, 
to improve the clarity of the plot}

\item{order}{Boolean, default (TRUE) is to order according to first positive in Y,
then first zero in Y, then first zero in R; if FALSE order of occurrence in data is used}

\item{do_plot}{Boolean, default (TRUE) shows the plot, if FALSE object is returned but not plotted}
}
\value{
a ggplot object (Grob)
}
\description{
Plot probabilities as a raster`
}
\examples{
\donttest{
icf <- icfit(Surv(left, right, type='interval2') ~ period + gender + age,
  data=drugusers)
rasterplot(icf)
rasterplot(icf, type = 'R')
rasterplot(icf, type = 'Y')
rasterplot(icf, pow = 0.05) # very small power basically shows 0/1
sel <- c(
  11, 18,  # right-censored, event in (L, \infty)
  1:2,     # event in (0, R)
  115, 133 # event in (L, R)
)
rasterplot(icf, sel = sel)
rasterplot(icf, sel = sel, label = c("e", "p", "g", "c", "m", "n"), show_label = TRUE)
rasterplot(icf, sel = sel, label = c("e", "p", "g", "c", "m", "n"), show_label = TRUE,
  type = 'Y')
}

}
