% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get.artifacts.R
\name{get.artifacts}
\alias{get.artifacts}
\title{Get a List of TAF Artifacts}
\usage{
get.artifacts(year = NULL, stock = NULL, ...)
}
\arguments{
\item{year}{the assessment year, e.g. 2015, default all years.}

\item{stock}{a stock name, e.g. lin.27.5a, default all stocks.}

\item{...}{arguments passed to \code{\link{taf_get}}.}
}
\value{
A data frame.
}
\description{
Get a list of TAF artifacts and their metadata, i.e., all the FLStocks,
SAG upload files, RCEF files, and other files uploaded to TAF.
}
\examples{
\dontrun{
artifacts <- get.artifacts(2023)
nshad_artifacts <- get.artifacts(stock = "had.27.46a20")
}
}
\seealso{
\code{\link{icesTAF-package}} gives an overview of the package.
}
\author{
Colin Millar.
}
