% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expand_data.R
\name{expand_data}
\alias{expand_data}
\title{Complete incomplete data}
\usage{
expand_data(data, y, missing.x, value.set, weights = rep.int(1, NROW(data)),
                   indicator = rep.int(0, NROW(data)))
}
\arguments{
\item{data}{a vector, matrix, list or data frame containing numerics. This data is checked for incompleteness and needs to contain the independent variables for a subsequent regression with n observations and k regressors. Each gap is filled with all values from \code{value.set}. New observations are added for each possible value.}

\item{y}{a vector of integers or numerics. This vector has to be complete and is the dependent variable for a subsequent regression.}

\item{missing.x}{a vector that contains integers and gives the position of the independent variables, for which the data will be checked for incompleteness, i.e. for a matrix the position of the corresponding columns.}

\item{value.set}{a vector of numerics containing all possible values the missing data can take. This set has to be finite.}

\item{weights}{a vector of numerics giving the initial weight of each observation. Default is 1 for each observation.}

\item{indicator}{a vector of integers that indicates which observations belong to each other. If some columns with incomplete data were already completed, this vector has to be passed here. For raw incomplete data, the function connects observations which belong to each other. Default is 0 for this vector indicating no connection.}
}
\value{
\code{expand_data} returns a list with the following elements:
\itemize{
\item{data}{a data frame of the expanded data with all possible observations (independent variables). The dependent variable is included in the last column.}
\item{weights}{the weights for each possible observation.}
\item{indicator}{a vector which indicates which observations belong to each other. Such observations have the same integer being the indicator.}
}
}
\description{
This function fills all incomplete data with a set of possible values equally weighted. This is done in order to apply \emph{\link{icdglm}}.
}
\examples{
data(TLI.data)
          expand_data(data = TLI.data[,1:3],
          y = TLI.data[,4],
          missing.x = 1:3,
          value.set = 0:1)
}

