% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cumprob.R
\name{cumprob}
\alias{cumprob}
\title{Calculate cumulative probabilities for state transitions.}
\usage{
cumprob(probs, actual = FALSE)
}
\arguments{
\item{probs}{A numeric vector of the probabilities of transition to states.}

\item{actual}{A logical value, if TRUE, will calculate actual cumulative probabilities which may surpass 1!.}
}
\value{
A numeric vector of cumulative probabilites inclusive of the probability of having the same state in the next timestep.
}
\description{
This function takes in a vector of probabilities of states transitions and calculate the probability of staying in the original state and output the cumulative probabilities for all possibilities.
}
\examples{
cumprob(c(.2,.2,.9))
cumprob(c(.2,.2,.9), actual=TRUE)
cumprob(c(.2,.2,.2))

}

