% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotIBD.R
\name{plotIBD}
\alias{plotIBD}
\title{Plot IBD segments and posteriors}
\usage{
plotIBD(
  x,
  segments = NULL,
  chrom = NULL,
  ncol = NULL,
  title = NA,
  base_size = 12,
  refSegs = NULL
)
}
\arguments{
\item{x}{A list, typically produced with \code{\link[=findIBD]{findIBD()}}, containing data frames
named \code{posteriors} and \code{segments}. Alternatively, \code{x} may be just the
output of \code{\link[=ibdPosteriors]{ibdPosteriors()}}.}

\item{segments}{A data frame with IBD segments, typically produced by
\code{\link[=findSegments]{findSegments()}}.}

\item{chrom}{A vector of chromosomes to plot (default: all).}

\item{ncol}{Number of columns in the plot. By default a suitable layout is
chosen automatically.}

\item{title}{Plot title. Generated automatically if \code{NA} (default).}

\item{base_size}{Base font size.}

\item{refSegs}{(Optional) A data frame with true IBD segments, mostly for
testing and validation purposes. If provided, these segments are plotted in
blue.}
}
\value{
A \code{ggplot2} plot.
}
\description{
Plot IBD segments and posteriors
}
\examples{
x = subset(cousinsDemo, CHROM \%in\% 3:4)
ibd = findIBD(x, k1 = 0.2, a = 5)
plotIBD(ibd)

}
\seealso{
\code{\link[=findIBD]{findIBD()}}, \code{\link[=findSegments]{findSegments()}}, \code{\link[=ibdPosteriors]{ibdPosteriors()}}
}
