% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ispls.plot.R
\name{ispls.plot}
\alias{ispls.plot}
\title{Plot the results of ispls}
\usage{
ispls.plot(x, type)
}
\arguments{
\item{x}{list of "ispls", which is the result of command "ispls".}

\item{type}{character, "path", "loading" or "heatmap" type, if "path", plot the the convergence path graph of vector w in the integrative sparse partial least squares model, if "loading", plot the the first direction vectors, if "heatmap", show the heatmap of regression coefficients among different datasets.}
}
\value{
show the convergence path graph of the first direction vector w or the regression coefficients.
}
\description{
Plot the convergence path graph of the first direction vector w in the integrative sparse partial least squares model or show the regression coefficients.
}
\details{
See details in \code{\link{ispls}}.
}
\examples{
library(iSFun)
data("simData.pls")
x <- simData.pls$x
y <- simData.pls$y
L <- length(x)

res_homo_m <- ispls(x = x, y = y, L = L, mu1 = 0.05, mu2 = 0.25,
                    eps = 5e-2, trace = FALSE, draw = FALSE)
ispls.plot(x = res_homo_m, type = "path")
ispls.plot(x = res_homo_m, type = "loading")
ispls.plot(x = res_homo_m, type = "heatmap")
}
