% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iscca.plot.R
\name{iscca.plot}
\alias{iscca.plot}
\title{Plot the results of iscca}
\usage{
iscca.plot(x, type)
}
\arguments{
\item{x}{list of "iscca", which is the result of command "iscca".}

\item{type}{character, "path" or "loading" type, if "path", plot the the convergence path graph of vector u and v in the integrative sparse canonical correlation analysis method, if "loading", show the the first pair of canonical vectors.}
}
\value{
the convergence path graph or the scatter diagrams of the first pair of canonical vectors.
}
\description{
Plot the convergence path graph in the integrative sparse canonical correlation analysis method or show the the first pair of canonical vectors.
}
\details{
See details in \code{\link{iscca}}.
}
\examples{
library(iSFun)
data("simData.cca")
x <- simData.cca$x
y <- simData.cca$y
L <- length(x)
mu1 <- mu3 <- 0.4
mu2 <- mu4 <- 2.5

res_homo_m <- iscca(x = x, y = y, L = L, mu1 = mu1, mu2 = mu2, mu3 = mu3,
                    mu4 = mu4, eps = 5e-2, maxstep = 100, trace = FALSE, draw = FALSE)
iscca.plot(x = res_homo_m, type = "path")
iscca.plot(x = res_homo_m, type = "loading")
}
