% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilityFunctions.R
\name{roc2binary}
\alias{roc2binary}
\title{Convert ROC data formatted for doIMRMC to TPF and FPF data formatted for doIMRMC}
\usage{
roc2binary(df.auc, threshold)
}
\arguments{
\item{df.auc}{data frame of roc scores formatted for doIMRMC}

\item{threshold}{The threshold for determining binary decisions}
}
\value{
a list of two data frames (df.tpf and df.fpf) both formatted for doIMRMC
}
\description{
Convert ROC data formatted for doIMRMC to TPF and FPF data formatted for doIMRMC
}
\examples{
# Create a sample configuration file
config <- sim.gRoeMetz.config()
# Simulate an MRMC ROC data set
dFrame.imrmc <- sim.gRoeMetz(config)
# Convert ROC MRMC data to TPF and FPF data frames
result <- roc2binary(dFrame.imrmc, threshold = 0.9)
# Analyze TPF data using doIMRMC
tpf_result <- doIMRMC(result$df.tpf)
# View(tpf_result$perReader)
}
