% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iCARH.simulate.R
\name{iCARH.simulate}
\alias{iCARH.simulate}
\title{Simulates longitudinal data based on the iCARH model.}
\usage{
iCARH.simulate(
  Tp,
  N,
  J,
  P,
  K,
  path.names = NULL,
  path.probs = FALSE,
  pathway.perturb.ratio = 0.5,
  Ygroupeff = NULL,
  Zgroupeff = NULL,
  fe = 0,
  num.corr.y = 0,
  beta.val = NULL,
  sigma2 = 1,
  arz = 0.7,
  sdx = 0.01
)
}
\arguments{
\item{Tp}{number of time points}

\item{N}{number of samples (by default first N/2 controls and last N/2 cases)}

\item{J}{number of metabolites}

\item{P}{number of pathways (will probably change)}

\item{K}{number of bacteria profiles (Y variables)}

\item{path.names}{pathways to sample from as specified in KEGG. If not specified, path.probs will be considered.}

\item{path.probs}{if TRUE, KEGG like density of pathways per metabolite is used to sample from.
If scalar, path.probs is the expected ratio of metabolites in each pathway. Needs to be specified if
path.names is not.}

\item{pathway.perturb.ratio}{expected ratio of perturbed pathways}

\item{Ygroupeff}{vector of 2xK variables (treatment effect on Y variables)}

\item{Zgroupeff}{vector of 2 variables for treatment effect}

\item{fe}{fixed effect}

\item{num.corr.y}{number of correlated Y variables. The last num.corr.y will be highly
correlated to the first num.corr.y variables}

\item{beta.val}{beta values (regression coefficients) to sample from. Values will be randomly sampled if not specified.}

\item{sigma2}{individual variance of metabolites}

\item{arz}{autoregressive coefficient for treatment simulation}

\item{sdx}{noise for autoregressive process, recommended value is 0.01}
}
\value{
list with the following objects :
\item{XX}{metabolomics data, X data}
\item{Y}{additional omic data, Y data}
\item{Z}{treatment}
\item{beta}{effects of Y variables on X variables, column K+1 represents effect of treatment on X variables}
\item{pathways}{pathway adjacency matrices}
\item{path.perturb}{which pathways are perturbed?}
\item{phi}{"spatial" dependence parameter, indicative of pathway perturbation}
\item{arx}{autoregressive coefficients for X data}
\item{ary}{autoregressive coefficients for Y data}
}
\description{
Simulates longitudinal data based on the iCARH model.
Returns two types of datasets with relevant parameters (see below).
}
\examples{
 data.sim = iCARH.simulate(4, 8, 10, 2, 2, path.probs=0.3, Zgroupeff=c(0,4),
beta.val=c(1,-1,0.5, -0.5))

}
