% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasets.R
\docType{data}
\name{day_periods}
\alias{day_periods}
\title{A table with rule sets for naming periods of a day}
\format{
An object of class \code{tbl_df} (inherits from \code{tbl}, \code{data.frame}) with 519 rows and 5 columns.
}
\usage{
day_periods
}
\description{
The \code{day_periods} table contains rules for naming periods of time throughout
a day. There are 519 rows that comprise a day period name
and rule for a locale. There may be only two rows associated with a locale
but many more if a locale has many names for periods of a day. The following
columns are included:
\itemize{
\item \code{locale} (\code{character})
\item \code{period} (\code{character})
\item \code{from} (\code{character})
\item \code{to} (\code{character})
\item \code{at} (\code{character})
}

The \code{period} value provides an identifier for the period of time. For a given
locale there may typically be \code{"afternoon1"} and \code{"evening1"} period
identifiers. Some may have quite a few periods defined (perhaps with
\code{"morning1"} and \code{"morning2"} rules). A period is either a block of time
defined by the \code{from} and \code{to} columns, or, a set time (like \code{"noon"} and
\code{"midnight"}) found in the \code{at} column. The \code{period} values are typically
obtained from this dataset in order to obtain localized text from
the \link{dates} and \link{dates_generic} datasets (within the \verb{dayperiods_*} columns).
}
\keyword{datasets}
