% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_values.R
\name{cldr_dates}
\alias{cldr_dates}
\title{Get a single localized value from the \link{dates} dataset}
\usage{
cldr_dates(locale = "en", element = dates_elements$months_format_abbrev)
}
\arguments{
\item{locale}{The locale ID for which to obtain the data from the
\link{dates} table.}

\item{element}{The element from which information will be obtained for the
specified \code{locale}.}
}
\value{
A named list.
}
\description{
The \link{dates} table contains information on how to express dates and this data
is localized across 574 locales. The \code{cldr_dates()}
function allows one to extract a named list using a \code{locale} and a specific
\code{element}. The element values are:
\itemize{
\item \code{"months_format_abbrev"}
\item \code{"months_format_narrow"}
\item \code{"months_format_wide"}
\item \code{"days_standalone_narrow"}
\item \code{"days_standalone_short"}
\item \code{"days_standalone_wide"}
\item \code{"quarters_format_abbrev"}
\item \code{"quarters_format_narrow"}
\item \code{"quarters_format_wide"}
\item \code{"quarters_standalone_abbrev"}
\item \code{"quarters_standalone_narrow"}
\item \code{"quarters_standalone_wide"}
\item \code{"dayperiods_format_abbrev"}
\item \code{"dayperiods_format_narrow"}
\item \code{"dayperiods_format_wide"}
\item \code{"dayperiods_standalone_abbrev"}
\item \code{"dayperiods_standalone_narrow"}
\item \code{"dayperiods_standalone_wide"}
\item \code{"eras_abbrev"}
\item \code{"eras_names"}
\item \code{"eras_narrow"}
\item \code{"date_formats"}
\item \code{"date_skeletons"}
\item \code{"time_formats"}
\item \code{"time_skeletons"}
\item \code{"date_time_available_formats"}
\item \code{"date_time_append_items"}
\item \code{"date_time_interval_formats"}
}
}
