% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cube.R
\docType{methods}
\name{plot,Cube-method}
\alias{plot,Cube-method}
\title{Visualizes a Cube object as parallel coordinate plot}
\usage{
\S4method{plot}{Cube}(x, color = NA, colorscale = "RdBu", ...)
}
\arguments{
\item{x}{The \code{Cube} object that should be plotted.}

\item{color}{The color of the lines in the parallel coordinate plot. If this parameter is NA or NULL, a colorscale rather than a unique color will be used.}

\item{colorscale}{The colorscale for the lines in the parallel coordinate plot. Default is RdBu. All plotly colorscales (e.g., Blackbody, Earth, Jet) are possible.}

\item{...}{Further plot_ly parameters.}
}
\description{
Generates a parallel coordinate plot for a given \code{Cube} object. All added selections and aggregations will be
regarded.
}
\examples{

data("sales")
cube = generateCube(sales, columns = list(time = c("month", "year"),
      location = c("state"), product = "product"), valueColumn = "amount")
plot(cube)

}
\seealso{
\code{\link[=Cube-class]{Cube}}
}
\author{
Michael Scholz \email{michael.scholz@th-deg.de}
}
\keyword{methods}
