% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/06_hm_plot.R
\name{hm_plot}
\alias{hm_plot}
\alias{hm_plot,hydromet_station-method}
\alias{hm_plot,hydromet_compact-method}
\title{Methods to easily use \code{ggplot2} or \code{plotly} (interactive)}
\usage{
hm_plot(
  obj,
  slot_name,
  col_name,
  interactive = FALSE,
  line_type = NULL,
  line_color = NULL,
  line_size = NULL,
  line_alpha = NULL,
  x_lab = "date",
  y_lab = "y",
  title_lab = NULL,
  legend_lab = NULL,
  dual_yaxis = NULL,
  from = NULL,
  to = NULL,
  scatter = NULL
)

\S4method{hm_plot}{hydromet_station}(
  obj,
  slot_name,
  col_name,
  interactive = FALSE,
  line_type = NULL,
  line_color = NULL,
  line_size = NULL,
  line_alpha = NULL,
  x_lab = "date",
  y_lab = "y",
  title_lab = NULL,
  legend_lab = NULL,
  dual_yaxis = NULL,
  from = NULL,
  to = NULL,
  scatter = NULL
)

\S4method{hm_plot}{hydromet_compact}(
  obj,
  slot_name,
  col_name,
  interactive = FALSE,
  line_type = NULL,
  line_color = NULL,
  line_size = NULL,
  line_alpha = NULL,
  x_lab = "date",
  y_lab = "y",
  title_lab = NULL,
  legend_lab = NULL,
  dual_yaxis = NULL,
  from = NULL,
  to = NULL,
  scatter = NULL
)
}
\arguments{
\item{obj}{a valid \code{hydromet_XXX} class object.}

\item{slot_name}{string vector with the name of the slot(s) to use in plotting.}

\item{col_name}{list containing the column name of the variables to plot. Every element inside
the list belongs to the previous defined slot(s).}

\item{interactive}{logical. Default value, \code{FALSE}, will return a \code{ggplot2}
class object. Otherwise you will get a \code{plotly} one.}

\item{line_type}{string with the name of the line dash type (\code{ggplot2}) or mode in
the \code{plotly} case. \code{ggplot2}: \code{'solid'} (default value), \code{'twodash'},
 \code{'longdash'}, \code{'dotted'}, \code{'dotdash'}, \code{'dashed'} or \code{'blank'}.
 \code{plotly}: \code{'lines'} (default value), \code{'lines+markers'} or \code{'markers'}.
 \bold{NOTE:} when using \code{scatter} plot this arguments goes through the \code{shape}
 argument (in \code{geom_point()}) as numeric.}

\item{line_color}{string with a valid \code{color} name. See \code{'colors()'} or
\href{http://www.stat.columbia.edu/~tzheng/files/Rcolor.pdf}{Rcolor document}.}

\item{line_size}{numeric vector containing the size of every line to plot. If you use
the \code{NULL} value it will return the plots with default(s) for either
 \code{ggplot2} or \code{plotly}.}

\item{line_alpha}{numeric vector with line(s) transparency. From 0 (invisible) to 1.}

\item{x_lab}{string with \code{x axis} label. Default is \code{'Date'}.}

\item{y_lab}{string with \code{y axis} label. In case you use \code{dual_yaxis}
argument you must supply both \code{c('ylab', 'y2lab')}.}

\item{title_lab}{string with the title of the plot. Default is a plot without title.}

\item{legend_lab}{string vector with plot label(s) name(s).}

\item{dual_yaxis}{string vector suggesting which variables are assign either to
the \code{'left'} or \code{'right'} y axis.}

\item{from}{string value for \code{'Date'} class or \code{POSIXct(lt)} class
for date-time data with the starting \code{Date}. You can use \code{'from'}
without \code{'to'}. In this case you will subset your data \code{'from'} till the end.}

\item{to}{string value for \code{'Date'} class or \code{POSIXct(lt)} class for date-time
data with the ending \code{Date}. You can use \code{'to'} without \code{'from'}.
In this case you will subset your data from the beginning till \code{'to'}.}

\item{scatter}{string vector (of length two) suggesting which variables goes in
the \code{'x'} and \code{'y'} axis respectively. Valid character entries
are \code{'x'} and \code{'y'}.}
}
\value{
A \code{ggplot2} or \code{plotly} object.
}
\description{
This method allows you to make plots (using simple and expressive arguments)
 of the variables contained inside an \code{hydromet_XXX} class object.
 The plot outputs can be static (\code{ggplot2}) or dynamic (\code{plotly}).
}
\section{Functions}{
\itemize{
\item \code{hm_plot(hydromet_station)}: plot method for station class

\item \code{hm_plot(hydromet_compact)}: plot method for compact class

}}
\examples{
\dontrun{
# lets work with the cuevas station
path <- system.file('extdata', package = 'hydrotoolbox')

# use the build method
hm_cuevas <-
  hm_create() \%>\%
  hm_build(bureau = 'ianigla', path = path,
           file_name = 'ianigla_cuevas.csv',
           slot_name = c('tair', 'rh', 'patm',
                         'precip', 'wspd', 'wdir',
                         'kin', 'hsnow', 'tsoil'),
           by = 'hour',
           out_name = c('tair(°C)', 'rh(\%)', 'patm(mbar)',
                        'p(mm)', 'wspd(km/hr)', 'wdir(°)',
                        'kin(kW/m2)', 'hsnow(cm)', 'tsoil(°C)' )
           )

# let's start by making a single variable static plot
hm_plot(obj = hm_cuevas, slot_name = 'tair',
        col_name = list('tair(°C)') )

# we add labels, change color, line type and we focus
# on specific date range
hm_plot(obj = hm_cuevas, slot_name = 'tair',
        col_name = list('tair(°C)'),
        line_type = 'longdash',
        line_color = 'dodgerblue',
        x_lab = 'Date time', y_lab = 'T(°C)',
        title_lab = 'Hourly temperature at Cuevas',
        legend_lab = 'Tair',
        from = ISOdate(2020, 7, 1),
        to = ISOdate(2020, 7, 5))

# compare air with soil temperature
hm_plot(obj = hm_cuevas, slot_name = c('tair', 'tsoil'),
        col_name = list('tair(°C)', 'tsoil(°C)'),
        line_type = c('longdash', 'solid'),
        line_color = c('dodgerblue', 'tan4'),
        x_lab = 'Date time', y_lab = 'T(°C)',
        title_lab = 'Hourly temperature at Cuevas',
        legend_lab = c('Tair', 'Tsoil'),
        from = ISOdate(2020, 7, 1),
        to = ISOdate(2020, 7, 5))

# let's add relative humidity on the right y-axis
hm_plot(obj = hm_cuevas, slot_name = c('tair', 'tsoil', 'rh'),
        col_name = list('tair(°C)', 'tsoil(°C)', 'rh(\%)'),
        line_type = c('longdash', 'solid', 'solid'),
        line_color = c('dodgerblue', 'tan4', 'red'),
        x_lab = 'Date time', y_lab = c('T(°C)', 'RH(\%)'),
        title_lab = 'Hourly meteo data at Cuevas',
        legend_lab = c('Tair', 'Tsoil', 'RH'),
        dual_yaxis = c('left', 'left', 'right'),
        from = ISOdate(2020, 7, 1),
        to = ISOdate(2020, 7, 5))

# we decide to analize the previous variables in detail
# with a dynamic plot
hm_plot(obj = hm_cuevas, slot_name = c('tair', 'tsoil', 'rh'),
        col_name = list('tair(°C)', 'tsoil(°C)', 'rh(\%)'),
        line_color = c('dodgerblue', 'tan4', 'red'),
        x_lab = 'Date time', y_lab = c('T(°C)', 'RH(\%)'),
        title_lab = 'Hourly meteo data at Cuevas',
        legend_lab = c('Tair', 'Tsoil', 'RH'),
        dual_yaxis = c('left', 'left', 'right'),
        interactive = TRUE)
# click on the Zoom icon and play a little...


# suppose now that we want to make a scatter plot to show
# the negative correlation between air temperature and
# relative humidity
hm_plot(obj = hm_cuevas, slot_name = c('tair', 'rh'),
        col_name = list('tair(°C)', 'rh(\%)'),
        line_color = 'dodgerblue',
        x_lab = 'Tair', y_lab = 'RH',
        scatter = c('x', 'y') )
}


}
