% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/navigation_network.R
\name{navigate_hydro_network}
\alias{navigate_hydro_network}
\alias{navigate_hydro_network.data.frame}
\alias{navigate_hydro_network.hy}
\title{Navigate Hydro Network}
\usage{
navigate_hydro_network(x, start, mode, distance = NULL)

\method{navigate_hydro_network}{data.frame}(x, start, mode, distance = NULL)

\method{navigate_hydro_network}{hy}(x, start, mode, distance = NULL)
}
\arguments{
\item{x}{data.frame network compatible with \link{hydroloom_names}.}

\item{start}{character or numeric to match identifier attribute. The
starting catchment is included.}

\item{mode}{character chosen from c(UM, DM, UT, or DD).

\enumerate{
\item UM: upstream mainstem
\item DM: downstream main
\item UT: upstream with tributaries
\item DD: downstream with diversions
}}

\item{distance}{numeric distance in km to limit navigation. The first
catchment that exceeds the provided distance is included.}
}
\value{
vector of identifiers found along navigation
}
\description{
Navigates a network of connected catchments using NHDPlus style
network attributes.
}
\details{
if only \code{mode} is supplied, require network attributes are displayed.

NOTE: for "Upstream with tributaries" navigation, if a tributary emanates from
a diversion and is the minor path downstream of that diversion, it will be
included. This can have a very large impact when a diversion between two
large river systems. To strictly follow the dendritic network, set the
"dn_minor_topo_sort" attribute to all 0 in x.
}
\examples{

plot_fun <- function(x, s, n) {
   plot(sf::st_geometry(x), col = "grey")
   plot(sf::st_geometry(x[x$id \%in\% n, ]), add = TRUE)
   plot(sf::st_geometry(x[x$id \%in\% s, ]), col = "red", lwd = 3, add = TRUE)
}

x <- hy(sf::read_sf(system.file("extdata/new_hope.gpkg", package = "hydroloom")))

start <- 8891126
dm <- navigate_hydro_network(x, start, "DM")

plot_fun(x, start, dm)

dd <- navigate_hydro_network(x, start, "DD")

plot_fun(x, start, dd)

start <- 8894356

um <- navigate_hydro_network(x, start, "UM")

plot_fun(x, start, um)

ut <- navigate_hydro_network(x, start, "UT")

plot_fun(x, start, ut)

}
