% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/align_names.R
\name{align_names}
\alias{align_names}
\title{Align Names to Hydroloom Convention}
\usage{
align_names(x)
}
\arguments{
\item{x}{data.frame network compatible with \link{hydroloom_names}.}
}
\value{
data.frame renamed to match hydroloom as possible.
}
\description{
this function aligns the attribute names in x
with those used in hydroloom. See \link{hydroloom_names} for how
to add more attribute name mappings if the attributes in your data
are not supported.

See \link{hydroloom_name_definitions} for definitions of the names
used in hydroloom.
}
\examples{
x <- sf::read_sf(system.file("extdata/new_hope.gpkg", package = "hydroloom"))

names(x)

x <- align_names(x)

names(x)

}
