% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_BDHI.R
\name{read_BDHI}
\alias{read_BDHI}
\title{Reads data from Base de Datos Hidrológica Integrada (BDHI) - Argentina}
\usage{
read_BDHI(file, colName, timeStep, is.Wdir = FALSE)
}
\arguments{
\item{file}{string with the name (including extension) of the file.}

\item{colName}{string with variable name. E.g.: Qmd(m3/s)}

\item{timeStep}{string with time step: 'month', 'day', 'day/3', '4h' or 'hour'. 
\itemize{
\item 'day': data recorded once a day 
\item 'month': data recorded monthly
\item '4h': applies to atmospheric pressure time series only
\item 'day/3': applies to wind related variables, relative humidity, and dry bulb temperature'
\item 'hour': in case you have to deal with hourly data.   
}}

\item{is.Wdir}{a logical value indicating if the variable is wind direction. Default value is set to FALSE.}
}
\value{
A data frame with two columns: date and variable. Gaps between dates are filled with \code{NA_real_} and duplicated rows are eliminated automatically.
}
\description{
Reads files downloaded from the Base de Datos Hidrológica Integrada (BDHI) as a data frame.
}
\examples{
# Relative path to raw data
full_path <- system.file('extdata', package = "hydroToolkit")

# Apply function
guido_Qmd <- read_BDHI(file = paste0(full_path, '/Qmd_Mendoza_Guido'), 
                colName = 'Q(m3/s)', timeStep = 'day')

}
