% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interpolate.R
\name{interpolate}
\alias{interpolate}
\title{Interpolation}
\usage{
interpolate(df, miss_table, threshold, method = "linear")
}
\arguments{
\item{df}{data frame with two columns: 'Date' or 'POSIXct' class in the first column and a numeric variable in the second one.}

\item{miss_table}{data frame with three columns: first and last date of interpolation (first and second column respectively). The last and third column, is a numeric with the number of steps to interpolate. See \link{report_miss_data}.}

\item{threshold}{numeric variable with the maximum number of dates in which to apply the interpolation.}

\item{method}{string with the interpolation method. In this version only 'linear' method is allowed.}
}
\value{
A data frame with date and the interpolated numeric variable.
}
\description{
This functions applies interpolation to fill in missing (or non-recorded) values.
}
\examples{
# Create BDHI hydro-met station
guido <- create_hydroMet(class_name = 'BDHI')

# List with meteorological variables (slots in BDHI's object)
cargar <- list('precip', 'Qmd', 'Qmm')

# Now assign as names the files
hydro_files   <- list.files( system.file('extdata', package = "hydroToolkit"), pattern = 'Guido' )
names(cargar) <- hydro_files

# Build the object with the met records
guido <- build_hydroMet(obj = guido, slot_list = cargar, 
               path = system.file('extdata', package = "hydroToolkit") )
               
# Get mean daily discharge and report miss data
Qmd  <- get_hydroMet(obj = guido, name = 'Qmd')[[1]]
miss <- report_miss_data(df = Qmd)

# Now interpolate miss values 
Qmd_fill <- interpolate(df = Qmd, miss_table = miss, threshold = 5, method = "linear")

}
