% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/04_get_hydroMet.R
\name{get_hydroMet}
\alias{get_hydroMet}
\alias{get_hydroMet,hydroMet-method}
\alias{get_hydroMet,hydroMet_BDHI-method}
\alias{get_hydroMet,hydroMet_DGI-method}
\alias{get_hydroMet,hydroMet_IANIGLA-method}
\alias{get_hydroMet,hydroMet_CR2-method}
\alias{get_hydroMet,hydroMet_compact-method}
\title{Get the slot(s) content(s)}
\usage{
get_hydroMet(obj, name = NA_character_)

\S4method{get_hydroMet}{hydroMet}(obj, name = NA_character_)

\S4method{get_hydroMet}{hydroMet_BDHI}(obj, name = NA_character_)

\S4method{get_hydroMet}{hydroMet_DGI}(obj, name = NA_character_)

\S4method{get_hydroMet}{hydroMet_IANIGLA}(obj, name = NA_character_)

\S4method{get_hydroMet}{hydroMet_CR2}(obj, name = NA_character_)

\S4method{get_hydroMet}{hydroMet_compact}(obj, name = NA_character_)
}
\arguments{
\item{obj}{an \code{hydroMet} or \code{hydroMet_XXX} class object.}

\item{name}{a valid single string or vector string with the required slot name(s).}
}
\value{
A list with the slot's data.
}
\description{
Extract the slots that you want from an \code{hydroMet} or \code{hydroMet_XXX} class.
}
\section{Functions}{
\itemize{
\item \code{get_hydroMet,hydroMet-method}: get method for generic hydroMet object

\item \code{get_hydroMet,hydroMet_BDHI-method}: get method for BDHI class

\item \code{get_hydroMet,hydroMet_DGI-method}: get method for DGI class

\item \code{get_hydroMet,hydroMet_IANIGLA-method}: get method for IANIGLA class

\item \code{get_hydroMet,hydroMet_CR2-method}: get method for CR2 class

\item \code{get_hydroMet,hydroMet_compact-method}: get method for \code{compact} class
}}

\examples{
# Create an IANIGLA object
cuevas <- create_hydroMet(class_name = 'IANIGLA')

# Extract one of its slots
tair <- get_hydroMet(obj = cuevas, name = 'tair')

}
