% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_hydroMet.R
\name{create_hydroMet}
\alias{create_hydroMet}
\title{Creates an hydroMet class or subclass.}
\usage{
create_hydroMet(class_name = "hydroMet")
}
\arguments{
\item{class_name}{string with the name of the class. Valid arguments are: \code{hydroMet}, \code{BDHI}, \code{CR2}, \code{DGI}, \code{IANIGLA} or \code{compact}.}
}
\value{
an S4 object of class \code{hydroMet}
}
\description{
This function is the constructor of \code{hydroMet} class and its subclasses.
}
\examples{
# Create class 'hydroMet'
met_station <- create_hydroMet(class_name = 'hydroMet')

# Subclass 'BDHI'
bdhi_station <- create_hydroMet(class_name = 'BDHI')

# Subclass 'DGI'
dgi_station <- create_hydroMet(class_name = 'DGI')

# Subclass 'CR2'
cr2_station <- create_hydroMet(class_name = 'CR2')

# Subclass 'IANIGLA'
ianigla_station <- create_hydroMet(class_name = 'IANIGLA')

}
