% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/agg_serie.R
\name{agg_serie}
\alias{agg_serie}
\title{Aggregates a data frame to a larger time period}
\usage{
agg_serie(
  df,
  fun,
  period,
  out_name,
  start_month = NULL,
  end_month = NULL,
  allow_NA = NULL
)
}
\arguments{
\item{df}{data frame with class \code{Date} or \code{POSIXct} in the first column. The function always aggregates the second column.}

\item{fun}{string containing one of the following functions: \option{mean}, \option{min}, \option{max} or \option{sum}.}

\item{period}{string with the period of aggregation: \option{hourly}, \option{daily}, \option{monthly}, \option{annual} or \option{climatic}. \bold{NOTE}: the 'climatic' option returns the all series annual statistics ('fun').}

\item{out_name}{string with the output column name of the variable to aggregate.}

\item{start_month}{optional. Numeric value of the first month. It only makes sense if the \option{period} is \option{annual}.}

\item{end_month}{optional. Numeric value of the last month. It only makes sense if the \option{period} is \option{annual}.}

\item{allow_NA}{optional. Numeric value with the maximum allowed number of \code{NA_real_} values.  By default the function will not tolerate any \code{NA_real_} in an aggregation period (and will return \code{NA_real_} instead).}
}
\value{
A data frame with to columns: the date and the aggregated variable.
}
\description{
This is a useful function to easily aggregate your data.
}
\examples{
# Path to file
dgi_path  <- system.file('extdata', package = "hydroToolkit")

toscas <- read_DGI(file = 'Toscas.xlsx', sheet = 'tmean', path = dgi_path)

# Monthly mean temperature
m_toscas <- agg_serie(df = toscas, fun = 'mean', period = 'monthly', out_name = 'T_month')

}
