% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotPairs.R
\name{plotPairs}
\alias{plotPairs}
\title{Plot Paired Events}
\usage{
plotPairs(
  data.1,
  data.2,
  events,
  dates = NULL,
  type = "hyet",
  color.list = rainbow(nrow(events)),
  xlab = "",
  ylab.1 = "",
  ylab.2 = "",
  cex.2 = 1,
  main = ""
)
}
\arguments{
\item{data.1}{The first data vector}

\item{data.2}{The second data vector}

\item{events}{The paired events data frame from \link{pairEvents}}

\item{dates}{Optional date vector}

\item{type}{The type of plot (see details)}

\item{color.list}{Vector of colours used for plotting}

\item{xlab}{x-axis label}

\item{ylab.1}{primary y-axis label}

\item{ylab.2}{secondary y-axis label}

\item{cex.2}{cex for secondary y-axis label}

\item{main}{Plot title}
}
\value{
No return value.
}
\description{
Wrapper function for plotting paired events.
}
\details{
If the type is \code{"hyet"} then \code{data.1} is plotted as a vertical lines and \code{data.2} as a line.
If the type is \code{"lineover"} then all data is plotted as lines.
}
\examples{
library(hydroEvents)
BFI_res = eventBaseflow(dataBassRiver)
POT_res = eventPOT(dataLoch)
pairs.1 = pairEvents(POT_res, BFI_res, type = 1, lag = 5)
pairs.3 = pairEvents(POT_res, BFI_res, type = 3, lag = 3)
d = as.Date("1974-06-30") + 0:(length(dataBassRiver)-1)
oldpar <- par(mar = c(3, 3.5, 2, 3.5), mfrow = c(2, 1))
plotPairs(dataLoch, dataBassRiver, pairs.1, dates = d, type = "hyet", xlab = "Date",
    ylab.1 = "Rain (mm)", ylab.2 = "Flow (ML/day)", main = "Matching Forward")
plotPairs(dataLoch, dataBassRiver, pairs.3, dates = d, type = "hyet", xlab = "Date",
    ylab.1 = "Flow (ML/day)", ylab.2 = "Rain (mm)", main = "Matching Backward")
par(oldpar)
}
\seealso{
\code{\link{pairEvents}}
}
\keyword{events}
\keyword{pairs}
\keyword{plot}
